/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.writes;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.netflix.astyanax.CassandraOperationType;
import com.netflix.astyanax.ColumnMutation;
import com.netflix.astyanax.Execution;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.ConsistencyLevelMapping;
import com.netflix.astyanax.cql.CqlAbstractExecutionImpl;
import com.netflix.astyanax.cql.CqlKeyspaceImpl;
import com.netflix.astyanax.cql.schema.CqlColumnFamilyDefinitionImpl;
import com.netflix.astyanax.cql.util.CFQueryContext;
import com.netflix.astyanax.cql.writes.CFMutationQueryGen;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.FloatSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.ShortSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class CqlColumnMutationImpl<K, C>
implements ColumnMutation {
    protected final CqlKeyspaceImpl.KeyspaceContext ksContext;
    protected final CFQueryContext<K, C> cfContext;
    protected final CqlColumnFamilyDefinitionImpl cfDef;
    protected final Object columnName;
    protected Object columnValue;
    private ColMutationType type = ColMutationType.UpdateColumn;
    private ConsistencyLevel consistencyLevel;
    private final AtomicReference<Long> timestamp = new AtomicReference<Object>(null);
    private final AtomicReference<Integer> ttl = new AtomicReference<Object>(null);
    private final CFMutationQueryGen queryGen;

    public CqlColumnMutationImpl(CqlKeyspaceImpl.KeyspaceContext ksCtx, CFQueryContext<K, C> cfCtx, Object cName) {
        this.ksContext = ksCtx;
        this.columnName = cName;
        this.cfContext = cfCtx;
        this.cfDef = (CqlColumnFamilyDefinitionImpl)this.cfContext.getColumnFamily().getColumnFamilyDefinition();
        this.queryGen = this.cfDef.getMutationQueryGenerator();
    }

    public ColumnMutation setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public ColumnMutation withRetryPolicy(RetryPolicy retry) {
        this.cfContext.setRetryPolicy(retry);
        return this;
    }

    public ColumnMutation withTimestamp(long newValue) {
        this.timestamp.set(newValue);
        return this;
    }

    public Execution<Void> putValue(String value, Integer ttl) {
        return this.putValue((Object)value, (Serializer)StringSerializer.get(), ttl);
    }

    public Execution<Void> putValue(byte[] value, Integer ttl) {
        return this.exec(ByteBuffer.wrap(value), ttl, CassandraOperationType.COLUMN_MUTATE);
    }

    public Execution<Void> putValue(byte value, Integer ttl) {
        byte[] bytes = new byte[]{value};
        return this.exec(ByteBuffer.wrap(bytes), ttl, CassandraOperationType.COLUMN_MUTATE);
    }

    public Execution<Void> putValue(short value, Integer ttl) {
        return this.putValue(value, (Serializer)ShortSerializer.get(), ttl);
    }

    public Execution<Void> putValue(int value, Integer ttl) {
        return this.putValue(value, (Serializer)IntegerSerializer.get(), ttl);
    }

    public Execution<Void> putValue(long value, Integer ttl) {
        return this.putValue(value, (Serializer)LongSerializer.get(), ttl);
    }

    public Execution<Void> putValue(boolean value, Integer ttl) {
        return this.putValue(value, (Serializer)BooleanSerializer.get(), ttl);
    }

    public Execution<Void> putValue(ByteBuffer value, Integer ttl) {
        return this.exec(value, ttl, CassandraOperationType.COLUMN_MUTATE);
    }

    public Execution<Void> putValue(Date value, Integer ttl) {
        return this.putValue((Object)value, (Serializer)DateSerializer.get(), ttl);
    }

    public Execution<Void> putValue(float value, Integer ttl) {
        return this.putValue((Object)Float.valueOf(value), (Serializer)FloatSerializer.get(), ttl);
    }

    public Execution<Void> putValue(double value, Integer ttl) {
        return this.putValue(value, (Serializer)DoubleSerializer.get(), ttl);
    }

    public Execution<Void> putValue(UUID value, Integer ttl) {
        return this.putValue((Object)value, (Serializer)UUIDSerializer.get(), ttl);
    }

    public <T> Execution<Void> putValue(T value, Serializer<T> serializer, Integer ttl) {
        if (this.cfDef.getClusteringKeyColumnDefinitionList().size() == 0) {
            return this.exec(value, ttl, CassandraOperationType.COLUMN_MUTATE);
        }
        if (this.cfContext.getColumnFamily().getDefaultValueSerializer().getComparatorType() == ByteBufferSerializer.get().getComparatorType()) {
            ByteBuffer valueBytes = value instanceof ByteBuffer ? (ByteBuffer)value : serializer.toByteBuffer(value);
            return this.exec(valueBytes, ttl, CassandraOperationType.COLUMN_MUTATE);
        }
        return this.exec(value, ttl, CassandraOperationType.COLUMN_MUTATE);
    }

    public Execution<Void> putGenericValue(Object value, Integer ttl) {
        return this.exec(value, ttl, CassandraOperationType.COLUMN_MUTATE);
    }

    public Execution<Void> putEmptyColumn(Integer ttl) {
        return this.exec(null, ttl, CassandraOperationType.COLUMN_MUTATE);
    }

    public Execution<Void> incrementCounterColumn(long amount) {
        this.type = ColMutationType.CounterColumn;
        return this.exec(amount, null, CassandraOperationType.COUNTER_MUTATE);
    }

    public Execution<Void> deleteColumn() {
        this.type = ColMutationType.DeleteColumn;
        return this.exec(null, null, CassandraOperationType.COLUMN_DELETE);
    }

    public Execution<Void> deleteCounterColumn() {
        this.type = ColMutationType.DeleteColumn;
        return this.exec(null, null, CassandraOperationType.COLUMN_DELETE);
    }

    private Execution<Void> exec(Object value, Integer overrideTTL, final CassandraOperationType opType) {
        final CqlColumnMutationImpl thisMutation = this;
        this.columnValue = value;
        if (overrideTTL != null) {
            this.ttl.set(overrideTTL);
        }
        return new CqlAbstractExecutionImpl<Void>(this.ksContext, this.cfContext){

            @Override
            public CassandraOperationType getOperationType() {
                return opType;
            }

            @Override
            public Statement getQuery() {
                BoundStatement bStmt = CqlColumnMutationImpl.this.queryGen.getColumnMutationStatement(thisMutation, false);
                if (thisMutation.getConsistencyLevel() != null) {
                    bStmt.setConsistencyLevel(ConsistencyLevelMapping.getCL(CqlColumnMutationImpl.this.getConsistencyLevel()));
                }
                return bStmt;
            }

            @Override
            public Void parseResultSet(ResultSet resultSet) {
                return null;
            }
        };
    }

    public Integer getTTL() {
        return this.ttl.get();
    }

    public Long getTimestamp() {
        return this.timestamp.get();
    }

    public String toString() {
        return this.columnName.toString();
    }

    public ColMutationType getType() {
        return this.type;
    }

    public Object getRowKey() {
        return this.cfContext.getRowKey();
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public static enum ColMutationType {
        UpdateColumn,
        CounterColumn,
        DeleteColumn;

    }
}

