/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cluster;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.net.InetAddress;

public class ClusterNode
implements Comparable<ClusterNode>,
Serializable {
    private String _clusterNodeId;
    private InetAddress _inetAddress;
    private int _port;
    private String _portalProtocol;

    public ClusterNode(String clusterNodeId, InetAddress inetAddress) {
        if (clusterNodeId == null) {
            throw new IllegalArgumentException("Cluster node ID is null");
        }
        if (inetAddress == null) {
            throw new IllegalArgumentException("Inet address is null");
        }
        this._clusterNodeId = clusterNodeId;
        this._inetAddress = inetAddress;
    }

    @Override
    public int compareTo(ClusterNode clusterNode) {
        InetAddress inetAddress = clusterNode._inetAddress;
        String hostAddress = this._inetAddress.getHostAddress();
        int value = hostAddress.compareTo(inetAddress.getHostAddress());
        if (value != 0) {
            return value;
        }
        if (this._portalProtocol == null || clusterNode._portalProtocol == null) {
            if (this._portalProtocol != null) {
                return 1;
            }
            if (clusterNode._portalProtocol != null) {
                return -1;
            }
            return 0;
        }
        value = this._portalProtocol.compareTo(clusterNode._portalProtocol);
        if (value != 0) {
            return value;
        }
        if (this._port > clusterNode._port) {
            value = 1;
        } else if (this._port < clusterNode._port) {
            value = -1;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClusterNode)) {
            return false;
        }
        ClusterNode clusterNode = (ClusterNode)obj;
        return Validator.equals(this._clusterNodeId, clusterNode._clusterNodeId);
    }

    public String getClusterNodeId() {
        return this._clusterNodeId;
    }

    public InetAddress getInetAddress() {
        return this._inetAddress;
    }

    public int getPort() {
        return this._port;
    }

    public String getPortalProtocol() {
        return this._portalProtocol;
    }

    public int hashCode() {
        return this._clusterNodeId.hashCode();
    }

    public void setPort(int port) {
        this._port = port;
    }

    public void setPortalProtocol(String portalProtocol) {
        this._portalProtocol = portalProtocol;
    }

    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append("{clusterNodeId=");
        sb.append(this._clusterNodeId);
        sb.append(", portalProtocol=");
        sb.append(this._portalProtocol);
        sb.append(", inetAddress=");
        sb.append(this._inetAddress);
        sb.append(", port=");
        sb.append(this._port);
        sb.append("}");
        return sb.toString();
    }
}

