/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.rpc;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.DatagramReceiveHandler;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.process.ProcessCallable;
import java.io.Serializable;

public class BootstrapRPCDatagramReceiveHandler
implements DatagramReceiveHandler {
    private static Log _log = LogFactoryUtil.getLog(BootstrapRPCDatagramReceiveHandler.class);

    @Override
    public void receive(RegistrationReference registrationReference, Datagram datagram) {
        Deserializer deserializer = new Deserializer(datagram.getDataByteBuffer());
        try {
            ProcessCallable processCallable = (ProcessCallable)deserializer.readObject();
            Serializer serializer = new Serializer();
            Object result = processCallable.call();
            serializer.writeObject((Serializable)result);
            Intraband intraband = registrationReference.getIntraband();
            intraband.sendDatagram(registrationReference, Datagram.createResponseDatagram(datagram, serializer.toByteBuffer()));
        }
        catch (Exception e) {
            _log.error("Unable to execute", e);
        }
    }
}

