/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsProcessor;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;

public class CollatedSpellCheckHitsProcessor
implements HitsProcessor {
    @Override
    public boolean process(SearchContext searchContext, Hits hits) throws SearchException {
        QueryConfig queryConfig = searchContext.getQueryConfig();
        if (!queryConfig.isCollatedSpellCheckResultEnabled()) {
            return true;
        }
        int collatedSpellCheckResultScoresThreshold = queryConfig.getCollatedSpellCheckResultScoresThreshold();
        if (hits.getLength() >= collatedSpellCheckResultScoresThreshold) {
            return true;
        }
        String collatedKeywords = SearchEngineUtil.spellCheckKeywords(searchContext);
        if (collatedKeywords.equals(searchContext.getKeywords())) {
            collatedKeywords = "";
        }
        hits.setCollatedSpellCheckResult(collatedKeywords);
        return true;
    }
}

