/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class SortedProperties
extends Properties {
    private Comparator<String> _comparator;
    private Set<String> _names;

    public SortedProperties() {
        this(null, null);
    }

    public SortedProperties(Comparator<String> comparator) {
        this(comparator, null);
    }

    public SortedProperties(Comparator<String> comparator, Properties properties) {
        this._comparator = comparator;
        this._names = comparator != null ? new TreeSet<String>(comparator) : new TreeSet<String>();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                this.setProperty(key, value);
            }
        }
    }

    public SortedProperties(Properties properties) {
        this(null, properties);
    }

    @Override
    public void clear() {
        super.clear();
        this._names.clear();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        TreeSet<Map.Entry<Object, Object>> set = new TreeSet<Map.Entry<Object, Object>>(new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> object1, Map.Entry<Object, Object> object2) {
                String key1 = String.valueOf(object1.getKey());
                String key2 = String.valueOf(object2.getKey());
                if (SortedProperties.this._comparator == null) {
                    return key1.compareTo(key2);
                }
                return SortedProperties.this._comparator.compare(key1, key2);
            }
        });
        set.addAll(super.entrySet());
        return set;
    }

    @Override
    public void list(PrintStream out) {
        System.out.println("-- listing properties --");
        Enumeration<String> enu = this.propertyNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            out.println(String.valueOf(name) + "=" + this.getProperty(name));
        }
    }

    @Override
    public void list(PrintWriter out) {
        System.out.println("-- listing properties --");
        Enumeration<String> enu = this.propertyNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            out.println(String.valueOf(name) + "=" + this.getProperty(name));
        }
    }

    public Enumeration<String> propertyNames() {
        return Collections.enumeration(this._names);
    }

    @Override
    public Object put(String key, String value) {
        if (this._names.contains(key)) {
            this._names.remove(key);
        }
        this._names.add(key);
        return super.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        this._names.remove(key);
        return super.remove(key);
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }
}

