/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.antivirus;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScanner;
import com.liferay.portlet.documentlibrary.antivirus.AntivirusScannerException;
import java.io.File;
import java.io.InputStream;

public class AntivirusScannerUtil {
    private static AntivirusScanner _antivirusScanner;

    public static AntivirusScanner getAntivirusScanner() {
        PortalRuntimePermission.checkGetBeanProperty(AntivirusScannerUtil.class);
        return _antivirusScanner;
    }

    public static boolean isActive() {
        AntivirusScanner antivirusScanner = AntivirusScannerUtil.getAntivirusScanner();
        if (antivirusScanner == null) {
            return false;
        }
        return antivirusScanner.isActive();
    }

    public static void scan(byte[] bytes) throws AntivirusScannerException, SystemException {
        if (AntivirusScannerUtil.isActive()) {
            AntivirusScannerUtil.getAntivirusScanner().scan(bytes);
        }
    }

    public static void scan(File file) throws AntivirusScannerException, SystemException {
        if (AntivirusScannerUtil.isActive()) {
            AntivirusScannerUtil.getAntivirusScanner().scan(file);
        }
    }

    public static void scan(InputStream inputStream) throws AntivirusScannerException, SystemException {
        if (AntivirusScannerUtil.isActive()) {
            AntivirusScannerUtil.getAntivirusScanner().scan(inputStream);
        }
    }

    public void setAntivirusScanner(AntivirusScanner antiVirusScanner) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _antivirusScanner = antiVirusScanner;
    }
}

