/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.shopping.util.comparator;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portlet.shopping.model.ShoppingItem;

public class ItemSKUComparator
extends OrderByComparator {
    public static final String ORDER_BY_ASC = "ShoppingItem.categoryId ASC, ShoppingItem.sku ASC";
    public static final String ORDER_BY_DESC = "ShoppingItem.categoryId DESC, ShoppingItem.sku DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"categoryId", "sku"};
    private boolean _ascending;

    public ItemSKUComparator() {
        this(false);
    }

    public ItemSKUComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        Long categoryId2;
        ShoppingItem item1 = (ShoppingItem)obj1;
        ShoppingItem item2 = (ShoppingItem)obj2;
        Long categoryId1 = new Long(item1.getCategoryId());
        int value = categoryId1.compareTo(categoryId2 = new Long(item2.getCategoryId()));
        if (value == 0) {
            String sku1 = item1.getSku();
            String sku2 = item2.getSku();
            value = sku1.compareTo(sku2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

