/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.GeoUtils;

public class GeoRect {
    public final double minLon;
    public final double maxLon;
    public final double minLat;
    public final double maxLat;

    public GeoRect(double minLon, double maxLon, double minLat, double maxLat) {
        if (!GeoUtils.isValidLon(minLon)) {
            throw new IllegalArgumentException("invalid minLon " + minLon);
        }
        if (!GeoUtils.isValidLon(maxLon)) {
            throw new IllegalArgumentException("invalid maxLon " + maxLon);
        }
        if (!GeoUtils.isValidLat(minLat)) {
            throw new IllegalArgumentException("invalid minLat " + minLat);
        }
        if (!GeoUtils.isValidLat(maxLat)) {
            throw new IllegalArgumentException("invalid maxLat " + maxLat);
        }
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.minLat = minLat;
        this.maxLat = maxLat;
        assert (maxLat >= minLat);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GeoRect(lon=");
        b.append(this.minLon);
        b.append(" TO ");
        b.append(this.maxLon);
        if (this.maxLon < this.minLon) {
            b.append(" (crosses dateline!)");
        }
        b.append(" lat=");
        b.append(this.minLat);
        b.append(" TO ");
        b.append(this.maxLat);
        b.append(")");
        return b.toString();
    }
}

