/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.appinfo;

import com.thoughtworks.xstream.annotations.XStreamOmitField;

public class LeaseInfo {
    public static final int DEFAULT_LEASE_RENEWAL_INTERVAL = 30;
    public static final int DEFAULT_LEASE_DURATION = 90;
    private int renewalIntervalInSecs = 30;
    private int durationInSecs = 90;
    private long registrationTimestamp;
    private long lastRenewalTimestamp;
    private long evictionTimestamp;
    private long serviceUpTimestamp;

    private LeaseInfo() {
    }

    public long getRegistrationTimestamp() {
        return this.registrationTimestamp;
    }

    public long getRenewalTimestamp() {
        return this.lastRenewalTimestamp;
    }

    public long getEvictionTimestamp() {
        return this.evictionTimestamp;
    }

    public long getServiceUpTimestamp() {
        return this.serviceUpTimestamp;
    }

    public int getRenewalIntervalInSecs() {
        return this.renewalIntervalInSecs;
    }

    public int getDurationInSecs() {
        return this.durationInSecs;
    }

    public static final class Builder {
        @XStreamOmitField
        private LeaseInfo result = new LeaseInfo();

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder setRegistrationTimestamp(long ts) {
            this.result.registrationTimestamp = ts;
            return this;
        }

        public Builder setRenewalTimestamp(long ts) {
            this.result.lastRenewalTimestamp = ts;
            return this;
        }

        public Builder setEvictionTimestamp(long ts) {
            this.result.evictionTimestamp = ts;
            return this;
        }

        public Builder setServiceUpTimestamp(long ts) {
            this.result.serviceUpTimestamp = ts;
            return this;
        }

        public Builder setDurationInSecs(int d) {
            if (d <= 0) {
                this.result.durationInSecs = 90;
            } else {
                this.result.durationInSecs = d;
            }
            return this;
        }

        public Builder setRenewalIntervalInSecs(int i) {
            if (i <= 0) {
                this.result.renewalIntervalInSecs = 30;
            } else {
                this.result.renewalIntervalInSecs = i;
            }
            return this;
        }

        public LeaseInfo build() {
            return this.result;
        }
    }
}

