/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.entitystore.FieldMapper;
import com.netflix.astyanax.entitystore.MappingUtils;
import com.netflix.astyanax.entitystore.SimpleCompositeBuilder;
import com.netflix.astyanax.entitystore.TTL;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.model.Equality;
import com.netflix.astyanax.query.ColumnPredicate;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;

public class CompositeEntityMapper<T, K> {
    private final Class<T> clazz;
    private final Integer ttl;
    private final Method ttlMethod;
    final FieldMapper<?> idMapper;
    private final String entityName;
    private List<FieldMapper<?>> components = Lists.newArrayList();
    private Set<String> validNames = Sets.newHashSet();
    private FieldMapper<?> valueMapper;
    private int bufferSize = 64;

    public CompositeEntityMapper(Class<T> clazz, Integer ttl, ByteBuffer prefix) {
        TTL ttlAnnotation;
        this.clazz = clazz;
        Entity entityAnnotation = clazz.getAnnotation(Entity.class);
        if (entityAnnotation == null) {
            throw new IllegalArgumentException("class is NOT annotated with @javax.persistence.Entity: " + clazz.getName());
        }
        this.entityName = MappingUtils.getEntityName(entityAnnotation, clazz);
        Integer tmpTtlValue = ttl;
        if (tmpTtlValue == null && (ttlAnnotation = clazz.getAnnotation(TTL.class)) != null) {
            int ttlAnnotationValue = ttlAnnotation.value();
            Preconditions.checkState((ttlAnnotationValue > 0 ? 1 : 0) != 0, (Object)("cannot define non-positive value for TTL annotation at class level: " + ttlAnnotationValue));
            tmpTtlValue = ttlAnnotationValue;
        }
        this.ttl = tmpTtlValue;
        Method tmpTtlMethod = null;
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(TTL.class)) continue;
            Preconditions.checkState((tmpTtlMethod == null ? 1 : 0) != 0, (Object)("Duplicate TTL method annotation on " + method.getName()));
            tmpTtlMethod = method;
            tmpTtlMethod.setAccessible(true);
        }
        this.ttlMethod = tmpTtlMethod;
        Field[] declaredFields = clazz.getDeclaredFields();
        FieldMapper tempIdMapper = null;
        Object tempEmbeddedEntityMapper = null;
        for (Field field : declaredFields) {
            javax.persistence.Column columnAnnotation;
            Id idAnnotation = field.getAnnotation(Id.class);
            if (idAnnotation != null) {
                Preconditions.checkArgument((tempIdMapper == null ? 1 : 0) != 0, (Object)"there are multiple fields with @Id annotation");
                field.setAccessible(true);
                tempIdMapper = new FieldMapper(field, prefix);
            }
            if ((columnAnnotation = field.getAnnotation(javax.persistence.Column.class)) == null) continue;
            field.setAccessible(true);
            FieldMapper fieldMapper = new FieldMapper(field);
            this.components.add(fieldMapper);
            this.validNames.add(fieldMapper.getName());
        }
        Preconditions.checkNotNull(tempIdMapper, (Object)"there are no field with @Id annotation");
        this.idMapper = tempIdMapper;
        Preconditions.checkNotNull((Object)(this.components.size() > 2 ? 1 : 0), (Object)"there should be at least 2 component columns and a value");
        this.valueMapper = this.components.remove(this.components.size() - 1);
    }

    void fillMutationBatch(MutationBatch mb, ColumnFamily<K, ByteBuffer> columnFamily, T entity) {
        try {
            ColumnListMutation clm = mb.withRow(columnFamily, this.idMapper.getValue(entity));
            clm.setDefaultTtl(this.getTtl(entity));
            try {
                ByteBuffer columnName = this.toColumnName(entity);
                ByteBuffer value = this.valueMapper.toByteBuffer(entity);
                clm.putColumn((Object)columnName, value);
            }
            catch (Exception e) {
                throw new PersistenceException("failed to fill mutation batch", (Throwable)e);
            }
        }
        catch (Exception e) {
            throw new PersistenceException("failed to fill mutation batch", (Throwable)e);
        }
    }

    void fillMutationBatchForDelete(MutationBatch mb, ColumnFamily<K, ByteBuffer> columnFamily, T entity) {
        try {
            ColumnListMutation clm = mb.withRow(columnFamily, this.idMapper.getValue(entity));
            clm.deleteColumn((Object)this.toColumnName(entity));
        }
        catch (Exception e) {
            throw new PersistenceException("failed to fill mutation batch", (Throwable)e);
        }
    }

    private Integer getTtl(T entity) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Integer retTtl = this.ttl;
        if (this.ttlMethod != null) {
            Object retobj = this.ttlMethod.invoke(entity, new Object[0]);
            retTtl = (Integer)retobj;
        }
        return retTtl;
    }

    private ByteBuffer toColumnName(Object obj) {
        SimpleCompositeBuilder composite = new SimpleCompositeBuilder(this.bufferSize, Equality.EQUAL);
        for (FieldMapper<?> mapper : this.components) {
            try {
                composite.addWithoutControl(mapper.toByteBuffer(obj));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return composite.get();
    }

    T constructEntity(K id, Column<ByteBuffer> column) {
        try {
            T entity = this.clazz.newInstance();
            this.idMapper.setValue(entity, id);
            this.setEntityFieldsFromColumnName(entity, column.getRawName().duplicate());
            this.valueMapper.setField(entity, column.getByteBufferValue().duplicate());
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to construct entity", (Throwable)e);
        }
    }

    T constructEntityFromCql(ColumnList<ByteBuffer> cl) {
        try {
            T entity = this.clazz.newInstance();
            Object id = this.idMapper.fromByteBuffer(((Column)Iterables.getFirst(cl, null)).getByteBufferValue());
            this.idMapper.setValue(entity, id);
            Iterator columnIter = cl.iterator();
            columnIter.next();
            for (FieldMapper<?> component : this.components) {
                component.setField(entity, ((Column)columnIter.next()).getByteBufferValue());
            }
            this.valueMapper.setField(entity, ((Column)columnIter.next()).getByteBufferValue());
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to construct entity", (Throwable)e);
        }
    }

    public K getEntityId(T entity) throws Exception {
        return (K)this.idMapper.getValue(entity);
    }

    @VisibleForTesting
    Field getId() {
        return this.idMapper.field;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String toString() {
        return String.format("EntityMapper(%s)", this.clazz);
    }

    public String getKeyType() {
        return this.idMapper.getSerializer().getComparatorType().getClassName();
    }

    Object fromColumn(K id, Column<ByteBuffer> c) {
        try {
            T entity = this.clazz.newInstance();
            this.idMapper.setValue(entity, id);
            this.setEntityFieldsFromColumnName(entity, c.getRawName().duplicate());
            this.valueMapper.setField(entity, c.getByteBufferValue().duplicate());
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to construct entity", (Throwable)e);
        }
    }

    void setEntityFieldsFromColumnName(Object entity, ByteBuffer columnName) throws IllegalArgumentException, IllegalAccessException {
        for (FieldMapper<?> component : this.components) {
            ByteBuffer data = CompositeEntityMapper.getWithShortLength(columnName);
            if (data != null) {
                byte end_of_component;
                if (data.remaining() > 0) {
                    component.setField(entity, data);
                }
                if ((end_of_component = columnName.get()) == Equality.EQUAL.toByte()) continue;
                throw new RuntimeException("Invalid composite column.  Expected END_OF_COMPONENT.");
            }
            throw new RuntimeException("Missing component data in composite type");
        }
    }

    public String getComparatorType() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompositeType(");
        sb.append(StringUtils.join((Collection)Collections2.transform(this.components, (Function)new Function<FieldMapper<?>, String>(){

            public String apply(FieldMapper<?> input) {
                return input.serializer.getComparatorType().getClassName();
            }
        }), (String)","));
        sb.append(")");
        return sb.toString();
    }

    public static int getShortLength(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }

    public static ByteBuffer getWithShortLength(ByteBuffer bb) {
        int length = CompositeEntityMapper.getShortLength(bb);
        return CompositeEntityMapper.getBytes(bb, length);
    }

    public static ByteBuffer getBytes(ByteBuffer bb, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.limit(copy.position() + length);
        bb.position(bb.position() + length);
        return copy;
    }

    String getValueType() {
        return this.valueMapper.getSerializer().getComparatorType().getClassName();
    }

    ByteBuffer[] getQueryEndpoints(Collection<ColumnPredicate> predicates) {
        ArrayListMultimap lookup = ArrayListMultimap.create();
        for (ColumnPredicate predicate : predicates) {
            Preconditions.checkArgument((boolean)this.validNames.contains(predicate.getName()), (Object)("Field '" + predicate.getName() + "' does not exist in the entity " + this.clazz.getCanonicalName()));
            lookup.put((Object)predicate.getName(), (Object)predicate);
        }
        SimpleCompositeBuilder start = new SimpleCompositeBuilder(this.bufferSize, Equality.GREATER_THAN_EQUALS);
        SimpleCompositeBuilder end = new SimpleCompositeBuilder(this.bufferSize, Equality.LESS_THAN_EQUALS);
        for (FieldMapper<?> mapper : this.components) {
            for (ColumnPredicate p : lookup.get((Object)mapper.getName())) {
                try {
                    this.applyPredicate(mapper, start, end, p);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Failed to serialize predicate '%s'", p.toString()), e);
                }
            }
        }
        return new ByteBuffer[]{start.get(), end.get()};
    }

    void applyPredicate(FieldMapper<?> mapper, SimpleCompositeBuilder start, SimpleCompositeBuilder end, ColumnPredicate predicate) {
        ByteBuffer bb = mapper.valueToByteBuffer(predicate.getValue());
        switch (predicate.getOp()) {
            case EQUAL: {
                start.addWithoutControl(bb);
                end.addWithoutControl(bb);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_EQUALS: {
                if (mapper.isAscending()) {
                    start.add(bb, predicate.getOp());
                    break;
                }
                end.add(bb, predicate.getOp());
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_EQUALS: {
                if (mapper.isAscending()) {
                    end.add(bb, predicate.getOp());
                    break;
                }
                start.add(bb, predicate.getOp());
            }
        }
    }
}

