/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.model;

import com.google.common.collect.Maps;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnMap;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class OrderedColumnMap<C>
implements ColumnMap<C> {
    private final LinkedHashMap<C, Column<C>> columns = Maps.newLinkedHashMap();

    public OrderedColumnMap() {
    }

    public OrderedColumnMap(Collection<Column<C>> columns) {
        this.addAll(columns);
    }

    @Override
    public OrderedColumnMap<C> add(Column<C> column) {
        this.columns.put(column.getName(), column);
        return this;
    }

    @Override
    public OrderedColumnMap<C> addAll(Collection<Column<C>> columns) {
        for (Column<C> column : columns) {
            this.columns.put(column.getName(), column);
        }
        return this;
    }

    @Override
    public Iterator<Column<C>> iterator() {
        return this.columns.values().iterator();
    }

    @Override
    public Column<C> get(C columnName) {
        return this.columns.get(columnName);
    }

    @Override
    public String getString(C columnName, String defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getStringValue();
    }

    @Override
    public Integer getInteger(C columnName, Integer defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getIntegerValue();
    }

    @Override
    public Double getDouble(C columnName, Double defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getDoubleValue();
    }

    @Override
    public Long getLong(C columnName, Long defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getLongValue();
    }

    @Override
    public byte[] getByteArray(C columnName, byte[] defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getByteArrayValue();
    }

    @Override
    public Boolean getBoolean(C columnName, Boolean defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getBooleanValue();
    }

    @Override
    public ByteBuffer getByteBuffer(C columnName, ByteBuffer defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getByteBufferValue();
    }

    @Override
    public Date getDate(C columnName, Date defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getDateValue();
    }

    @Override
    public UUID getUUID(C columnName, UUID defaultValue) {
        Column<C> column = this.columns.get(columnName);
        if (column == null) {
            return defaultValue;
        }
        return column.getUUIDValue();
    }

    @Override
    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public Map<C, Column<C>> asMap() {
        return this.columns;
    }
}

