/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.serializers;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.serializers.AbstractSerializer;
import com.netflix.astyanax.serializers.SerializerTypeInferer;
import java.nio.ByteBuffer;

public class TypeInferringSerializer<T>
extends AbstractSerializer<T>
implements Serializer<T> {
    private static final TypeInferringSerializer instance = new TypeInferringSerializer();

    public static <T> TypeInferringSerializer<T> get() {
        return instance;
    }

    @Override
    public ByteBuffer toByteBuffer(T obj) {
        return SerializerTypeInferer.getSerializer(obj).toByteBuffer(obj);
    }

    @Override
    public T fromByteBuffer(ByteBuffer byteBuffer) {
        throw new IllegalStateException("The type inferring serializer can only be used for data going to the database, and not data coming from the database");
    }
}

