/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;

public class SSTableSplitter {
    private final SplittingCompactionTask task;
    private CompactionInfo.Holder info;

    public SSTableSplitter(ColumnFamilyStore cfs, SSTableReader sstable, int sstableSizeInMB) {
        this.task = new SplittingCompactionTask(cfs, sstable, sstableSizeInMB);
    }

    public void split() throws IOException {
        this.task.execute(new StatsCollector());
    }

    public static class SplitController
    extends CompactionController {
        public SplitController(ColumnFamilyStore cfs, Collection<SSTableReader> toCompact) {
            super(cfs, Integer.MIN_VALUE);
        }

        @Override
        public boolean shouldPurge(DecoratedKey key, long maxDeletionTimestamp) {
            return false;
        }
    }

    public static class SplittingCompactionTask
    extends CompactionTask {
        private final int sstableSizeInMB;

        public SplittingCompactionTask(ColumnFamilyStore cfs, SSTableReader sstable, int sstableSizeInMB) {
            super(cfs, Collections.singletonList(sstable), Integer.MIN_VALUE);
            this.sstableSizeInMB = sstableSizeInMB;
            if (sstableSizeInMB <= 0) {
                throw new IllegalArgumentException("Invalid target size for SSTables, must be > 0 (got: " + sstableSizeInMB + ")");
            }
        }

        @Override
        protected CompactionController getCompactionController(Collection<SSTableReader> toCompact) {
            return new SplitController(this.cfs, toCompact);
        }

        @Override
        protected void replaceCompactedSSTables(Collection<SSTableReader> compacted, Collection<SSTableReader> replacements) {
        }

        @Override
        protected boolean newSSTableSegmentThresholdReached(SSTableWriter writer) {
            return writer.getOnDiskFilePointer() > (long)this.sstableSizeInMB * 1024L * 1024L;
        }

        @Override
        protected boolean partialCompactionsAcceptable() {
            return true;
        }
    }

    public class StatsCollector
    implements CompactionManager.CompactionExecutorStatsCollector {
        @Override
        public void beginCompaction(CompactionInfo.Holder ci) {
            SSTableSplitter.this.info = ci;
        }

        @Override
        public void finishCompaction(CompactionInfo.Holder ci) {
        }
    }
}

