/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.ExceptionCallback;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.RowCallback;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.connectionpool.OperationResult;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllRowsQueryTest
extends KeyspaceTests {
    private static final Logger LOG = LoggerFactory.getLogger(AllRowsQueryTest.class);
    public static ColumnFamily<String, String> CF_ALL_ROWS = ColumnFamily.newColumnFamily((String)"allrows", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        AllRowsQueryTest.initContext();
        keyspace.createColumnFamily(CF_ALL_ROWS, null);
        CF_ALL_ROWS.describe(keyspace);
        MutationBatch m = keyspace.prepareMutationBatch();
        for (char keyName = 'A'; keyName <= 'Z'; keyName = (char)(keyName + '\u0001')) {
            String rowKey = Character.toString(keyName);
            ColumnListMutation cfmStandard = m.withRow(CF_ALL_ROWS, (Object)rowKey);
            for (char cName = 'a'; cName <= 'z'; cName = (char)(cName + '\u0001')) {
                cfmStandard.putColumn((Object)Character.toString(cName), cName - 97 + 1, null);
            }
            m.withCaching(true);
            m.execute();
            m.discardMutations();
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_ALL_ROWS);
    }

    @Test
    public void getAllWithCallback() throws Exception {
        final AtomicLong counter = new AtomicLong();
        keyspace.prepareQuery(CF_ALL_ROWS).getAllRows().setRowLimit(30).setRepeatLastToken(false).setConcurrencyLevel(2).executeWithCallback((RowCallback)new RowCallback<String, String>(){

            public void success(Rows<String, String> rows) {
                for (Row row : rows) {
                    LOG.info("ROW: " + (String)row.getKey() + " " + row.getColumns().size());
                    counter.incrementAndGet();
                }
            }

            public boolean failure(ConnectionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                return false;
            }
        });
        LOG.info("Read " + counter.get() + " keys");
        Assert.assertEquals((long)26L, (long)counter.get());
    }

    @Test
    public void getAll() throws Exception {
        AtomicLong counter = new AtomicLong(0L);
        OperationResult rows = keyspace.prepareQuery(CF_ALL_ROWS).getAllRows().setConcurrencyLevel(2).setRowLimit(30).setExceptionCallback(new ExceptionCallback(){

            public boolean onException(ConnectionException e) {
                Assert.fail((String)e.getMessage());
                return true;
            }
        }).execute();
        for (Row row : (Rows)rows.getResult()) {
            counter.incrementAndGet();
            LOG.info("ROW: " + (String)row.getKey() + " " + row.getColumns().size());
        }
        LOG.info("Read " + counter.get() + " keys");
        Assert.assertEquals((long)26L, (long)counter.get());
    }
}

