/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test;

import com.google.common.collect.ImmutableMap;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class CounterColumnTests
extends KeyspaceTests {
    public static ColumnFamily<String, String> CF_COUNTER1 = ColumnFamily.newColumnFamily((String)"Counter1", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());

    @BeforeClass
    public static void init() throws Exception {
        CounterColumnTests.initContext();
        keyspace.createColumnFamily(CF_COUNTER1, (Map)ImmutableMap.builder().put((Object)"default_validation_class", (Object)"CounterColumnType").build());
        CF_COUNTER1.describe(keyspace);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CounterColumnTests.initContext();
        keyspace.dropColumnFamily(CF_COUNTER1);
    }

    @Test
    public void testIncrementCounter() throws Exception {
        long incrAmount = 100L;
        Column column = (Column)keyspace.prepareQuery(CF_COUNTER1).getRow((Object)"CounterRow1").getColumn((Object)"MyCounter").execute().getResult();
        long baseAmount = 0L;
        MutationBatch m = keyspace.prepareMutationBatch();
        m.withRow(CF_COUNTER1, (Object)"CounterRow1").incrementCounterColumn((Object)"MyCounter", incrAmount);
        m.execute();
    }

    @Test
    public void testDeleteCounter() throws Exception {
        String rowKey = "CounterRowDelete1";
        String counterName = "MyCounter";
        MutationBatch m = keyspace.prepareMutationBatch();
        m.withRow(CF_COUNTER1, (Object)rowKey).incrementCounterColumn((Object)counterName, 1L);
        m.execute();
    }
}

