/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.cql.test.entitymapper;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.cql.test.KeyspaceTests;
import com.netflix.astyanax.entitystore.DefaultEntityManager;
import com.netflix.astyanax.entitystore.EntityManager;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.serializers.StringSerializer;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import junit.framework.Assert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class EntityMapperTests
extends KeyspaceTests {
    private static ColumnFamily<String, String> CF_SAMPLE_TEST_ENTITY = ColumnFamily.newColumnFamily((String)"sampletestentity", (Serializer)StringSerializer.get(), (Serializer)StringSerializer.get());
    private static EntityManager<SampleTestEntity, String> entityManager;
    private static EntityManager<SampleTestCompositeEntity, String> compositeEntityManager;

    @BeforeClass
    public static void init() throws Exception {
        EntityMapperTests.initContext();
        keyspace.createColumnFamily(CF_SAMPLE_TEST_ENTITY, null);
        CF_SAMPLE_TEST_ENTITY.describe(keyspace);
        entityManager = new DefaultEntityManager.Builder().withEntityType(SampleTestEntity.class).withKeyspace(keyspace).withColumnFamily(CF_SAMPLE_TEST_ENTITY).build();
        compositeEntityManager = new DefaultEntityManager.Builder().withEntityType(SampleTestCompositeEntity.class).withKeyspace(keyspace).withColumnFamily(CF_SAMPLE_TEST_ENTITY).build();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        keyspace.dropColumnFamily(CF_SAMPLE_TEST_ENTITY);
    }

    @Test
    public void testSimpleEntityCRUD() throws Exception {
        String ID = "testSimpleEntityCRUD";
        SampleTestEntity testEntity = new SampleTestEntity();
        testEntity.id = "testSimpleEntityCRUD";
        testEntity.testInt = 1;
        testEntity.testLong = 2L;
        testEntity.testString = "testString1";
        testEntity.testDouble = 3.0;
        testEntity.testFloat = 4.0f;
        testEntity.testBoolean = true;
        entityManager.put((Object)testEntity);
        SampleTestEntity getEntity = (SampleTestEntity)entityManager.get((Object)"testSimpleEntityCRUD");
        Assert.assertNotNull((Object)getEntity);
        Assert.assertTrue((boolean)testEntity.equals(getEntity));
        entityManager.delete((Object)"testSimpleEntityCRUD");
        getEntity = (SampleTestEntity)entityManager.get((Object)"testSimpleEntityCRUD");
        Assert.assertNull((Object)getEntity);
    }

    @Test
    public void testSimpleEntityList() throws Exception {
        ArrayList<SampleTestEntity> entities = new ArrayList<SampleTestEntity>();
        ArrayList<String> ids = new ArrayList<String>();
        int entityCount = 11;
        for (int i = 0; i < entityCount; ++i) {
            SampleTestEntity testEntity = new SampleTestEntity();
            testEntity.id = "id" + i;
            testEntity.testInt = i;
            testEntity.testLong = i;
            testEntity.testString = "testString" + i;
            testEntity.testDouble = i;
            testEntity.testFloat = i;
            testEntity.testBoolean = true;
            entities.add(testEntity);
            ids.add("id" + i);
        }
        entityManager.put(entities);
        List getEntities = entityManager.get(ids);
        Assert.assertTrue((entityCount == getEntities.size() ? 1 : 0) != 0);
        int count = 0;
        for (SampleTestEntity e : getEntities) {
            Assert.assertTrue((count == e.testInt ? 1 : 0) != 0);
            Assert.assertTrue(((long)count == e.testLong ? 1 : 0) != 0);
            Assert.assertTrue((boolean)("testString" + count).equals(e.testString));
            ++count;
        }
        entityManager.delete(ids);
        getEntities = entityManager.get(ids);
        Assert.assertTrue((0 == getEntities.size() ? 1 : 0) != 0);
    }

    @Test
    public void testGetAll() throws Exception {
        ArrayList<SampleTestEntity> entities = new ArrayList<SampleTestEntity>();
        ArrayList<String> ids = new ArrayList<String>();
        int entityCount = 11;
        for (int i = 0; i < entityCount; ++i) {
            SampleTestEntity testEntity = new SampleTestEntity();
            testEntity.id = "id" + i;
            testEntity.testInt = i;
            testEntity.testLong = i;
            testEntity.testString = "testString" + i;
            testEntity.testDouble = i;
            testEntity.testFloat = i;
            testEntity.testBoolean = true;
            entities.add(testEntity);
            ids.add("id" + i);
        }
        entityManager.put(entities);
        List getEntities = entityManager.getAll();
        Assert.assertTrue((entityCount == getEntities.size() ? 1 : 0) != 0);
        for (SampleTestEntity e : getEntities) {
            String id = e.id;
            int i = Integer.parseInt(id.substring("id".length()));
            Assert.assertTrue((i == e.testInt ? 1 : 0) != 0);
            Assert.assertTrue(((long)i == e.testLong ? 1 : 0) != 0);
            Assert.assertTrue((boolean)("testString" + i).equals(e.testString));
        }
        entityManager.delete(ids);
        getEntities = entityManager.getAll();
        Assert.assertTrue((0 == getEntities.size() ? 1 : 0) != 0);
    }

    @Test
    public void testCompositeEntityCRUD() throws Exception {
        String ID = "testCompositeEntityCRUD";
        SampleTestCompositeEntity testEntity = new SampleTestCompositeEntity();
        testEntity.id = "testCompositeEntityCRUD";
        testEntity.testInt = 1;
        testEntity.testLong = 2L;
        testEntity.testString = "testString1";
        testEntity.testDouble = 3.0;
        testEntity.testFloat = 4.0f;
        testEntity.testBoolean = true;
        testEntity.inner = new SampleTestCompositeEntity.InnerEntity();
        testEntity.inner.testInnerInt = 11;
        testEntity.inner.testInnerLong = 22L;
        testEntity.inner.testInnerString = "testInnserString1";
        compositeEntityManager.put((Object)testEntity);
        SampleTestCompositeEntity getEntity = (SampleTestCompositeEntity)compositeEntityManager.get((Object)"testCompositeEntityCRUD");
        System.out.println(getEntity);
        Assert.assertNotNull((Object)getEntity);
        Assert.assertTrue((boolean)testEntity.equals(getEntity));
        entityManager.delete((Object)"testCompositeEntityCRUD");
        getEntity = (SampleTestCompositeEntity)compositeEntityManager.get((Object)"testCompositeEntityCRUD");
        Assert.assertNull((Object)getEntity);
    }

    @Entity
    public static class SampleTestCompositeEntity {
        @Id
        private String id;
        @Column(name="integer")
        private int testInt;
        @Column(name="long")
        private long testLong;
        @Column(name="string")
        private String testString;
        @Column(name="float")
        private float testFloat;
        @Column(name="double")
        private double testDouble;
        @Column(name="boolean")
        private boolean testBoolean;
        @Column(name="inner")
        private InnerEntity inner;

        public String toString() {
            return "SampleTestEntity [\nid=" + this.id + "\ntestInt=" + this.testInt + "\ntestLong=" + this.testLong + "\ntestString=" + this.testString + "\ntestFloat=" + this.testFloat + "\ntestDouble=" + this.testDouble + "\ntestBoolean=" + this.testBoolean + "\ninner = " + this.inner.toString() + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.testBoolean ? 1231 : 1237);
            long temp = Double.doubleToLongBits(this.testDouble);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + Float.floatToIntBits(this.testFloat);
            result = 31 * result + this.testInt;
            result = 31 * result + (int)(this.testLong ^ this.testLong >>> 32);
            result = 31 * result + (this.testString == null ? 0 : this.testString.hashCode());
            result = 31 * result + (this.inner == null ? 0 : this.inner.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampleTestCompositeEntity other = (SampleTestCompositeEntity)obj;
            boolean equal = true;
            equal &= this.id != null ? this.id.equals(other.id) : other.id == null;
            equal &= this.testInt == other.testInt;
            equal &= this.testLong == other.testLong;
            equal &= this.testBoolean == other.testBoolean;
            equal &= this.testString != null ? this.testString.equals(other.testString) : other.testString == null;
            equal &= Double.doubleToLongBits(this.testDouble) == Double.doubleToLongBits(other.testDouble);
            equal &= Float.floatToIntBits(this.testFloat) == Float.floatToIntBits(other.testFloat);
            return equal &= this.inner != null ? this.inner.equals(other.inner) : other.inner == null;
        }

        @Entity
        public static class InnerEntity {
            @Column(name="inner_integer")
            private int testInnerInt;
            @Column(name="inner_long")
            private long testInnerLong;
            @Column(name="inner_string")
            private String testInnerString;

            public String toString() {
                return "InnerEntity [\ninnerInt=" + this.testInnerInt + "\ninnerLong=" + this.testInnerLong + "\ninnerString=" + this.testInnerString + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.testInnerInt;
                result = 31 * result + (int)(this.testInnerLong ^ this.testInnerLong >>> 32);
                result = 31 * result + (this.testInnerString == null ? 0 : this.testInnerString.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                InnerEntity other = (InnerEntity)obj;
                boolean equal = true;
                equal &= this.testInnerInt == other.testInnerInt;
                equal &= this.testInnerLong == other.testInnerLong;
                return equal &= this.testInnerString != null ? this.testInnerString.equals(other.testInnerString) : other.testInnerString == null;
            }
        }
    }

    @Entity
    public static class SampleTestEntity {
        @Id
        private String id;
        @Column(name="integer")
        private int testInt;
        @Column(name="long")
        private long testLong;
        @Column(name="string")
        private String testString;
        @Column(name="float")
        private float testFloat;
        @Column(name="double")
        private double testDouble;
        @Column(name="boolean")
        private boolean testBoolean;

        public String toString() {
            return "SampleTestEntity [\nid=" + this.id + "\ntestInt=" + this.testInt + "\ntestLong=" + this.testLong + "\ntestString=" + this.testString + "\ntestFloat=" + this.testFloat + "\ntestDouble=" + this.testDouble + "\ntestBoolean=" + this.testBoolean + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.testBoolean ? 1231 : 1237);
            long temp = Double.doubleToLongBits(this.testDouble);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + Float.floatToIntBits(this.testFloat);
            result = 31 * result + this.testInt;
            result = 31 * result + (int)(this.testLong ^ this.testLong >>> 32);
            result = 31 * result + (this.testString == null ? 0 : this.testString.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampleTestEntity other = (SampleTestEntity)obj;
            boolean equal = true;
            equal &= this.id != null ? this.id.equals(other.id) : other.id == null;
            equal &= this.testInt == other.testInt;
            equal &= this.testLong == other.testLong;
            equal &= this.testBoolean == other.testBoolean;
            equal &= this.testString != null ? this.testString.equals(other.testString) : other.testString == null;
            equal &= Double.doubleToLongBits(this.testDouble) == Double.doubleToLongBits(other.testDouble);
            return equal &= Float.floatToIntBits(this.testFloat) == Float.floatToIntBits(other.testFloat);
        }
    }
}

