/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.AbstractColumnList;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.thrift.model.ThriftColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftCounterColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftCounterSuperColumnImpl;
import com.netflix.astyanax.thrift.model.ThriftSuperColumnImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.ColumnOrSuperColumn;
import org.apache.cassandra.thrift.CounterColumn;
import org.apache.cassandra.thrift.CounterSuperColumn;
import org.apache.cassandra.thrift.SuperColumn;

public class ThriftColumnOrSuperColumnListImpl<C>
extends AbstractColumnList<C> {
    private final List<ColumnOrSuperColumn> columns;
    private Map<C, ColumnOrSuperColumn> lookup;
    private final Serializer<C> colSer;

    public ThriftColumnOrSuperColumnListImpl(List<ColumnOrSuperColumn> columns, Serializer<C> colSer) {
        Preconditions.checkArgument((columns != null ? 1 : 0) != 0, (Object)"Columns must not be null");
        Preconditions.checkArgument((colSer != null ? 1 : 0) != 0, (Object)"Serializer must not be null");
        this.columns = columns;
        this.colSer = colSer;
    }

    public Iterator<Column<C>> iterator() {
        class IteratorImpl
        implements Iterator<Column<C>> {
            Iterator<ColumnOrSuperColumn> base;

            public IteratorImpl(Iterator<ColumnOrSuperColumn> base) {
                this.base = base;
            }

            @Override
            public boolean hasNext() {
                return this.base.hasNext();
            }

            @Override
            public Column<C> next() {
                ColumnOrSuperColumn column = this.base.next();
                if (column.isSetSuper_column()) {
                    SuperColumn sc = column.getSuper_column();
                    return new ThriftSuperColumnImpl<Object>(ThriftColumnOrSuperColumnListImpl.this.colSer.fromBytes(sc.getName()), sc);
                }
                if (column.isSetCounter_column()) {
                    CounterColumn cc = column.getCounter_column();
                    return new ThriftCounterColumnImpl<Object>(ThriftColumnOrSuperColumnListImpl.this.colSer.fromBytes(cc.getName()), cc);
                }
                if (column.isSetCounter_super_column()) {
                    CounterSuperColumn cc = column.getCounter_super_column();
                    return new ThriftCounterSuperColumnImpl<Object>(ThriftColumnOrSuperColumnListImpl.this.colSer.fromBytes(cc.getName()), cc);
                }
                if (column.isSetColumn()) {
                    org.apache.cassandra.thrift.Column c = column.getColumn();
                    return new ThriftColumnImpl<Object>(ThriftColumnOrSuperColumnListImpl.this.colSer.fromBytes(c.getName()), c);
                }
                throw new RuntimeException("Unknwon column type");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator is immutable");
            }
        }
        return new IteratorImpl(this.columns.iterator());
    }

    public Column<C> getColumnByName(C columnName) {
        ColumnOrSuperColumn column = this.getColumn(columnName);
        if (column == null) {
            return null;
        }
        if (column.isSetColumn()) {
            return new ThriftColumnImpl<C>(columnName, column.getColumn());
        }
        if (column.isSetCounter_column()) {
            return new ThriftCounterColumnImpl<C>(columnName, column.getCounter_column());
        }
        throw new UnsupportedOperationException("SuperColumn " + columnName + " has no value");
    }

    public Column<C> getColumnByIndex(int idx) {
        ColumnOrSuperColumn column = this.columns.get(idx);
        if (column == null) {
            return null;
        }
        if (column.isSetColumn()) {
            return new ThriftColumnImpl<Object>(this.colSer.fromBytes(column.getColumn().getName()), column.getColumn());
        }
        if (column.isSetCounter_column()) {
            return new ThriftCounterColumnImpl<Object>(this.colSer.fromBytes(column.getCounter_column().getName()), column.getCounter_column());
        }
        throw new UnsupportedOperationException("SuperColumn " + idx + " has no value");
    }

    public <C2> Column<C2> getSuperColumn(C columnName, Serializer<C2> colSer) {
        ColumnOrSuperColumn column = this.getColumn(columnName);
        if (column == null) {
            return null;
        }
        if (column.isSetSuper_column()) {
            SuperColumn sc = column.getSuper_column();
            return new ThriftSuperColumnImpl<Object>(colSer.fromBytes(sc.getName()), sc);
        }
        if (column.isSetCounter_super_column()) {
            CounterSuperColumn sc = column.getCounter_super_column();
            return new ThriftCounterSuperColumnImpl<Object>(colSer.fromBytes(sc.getName()), sc);
        }
        throw new UnsupportedOperationException("'" + columnName + "' is not a composite column");
    }

    public <C2> Column<C2> getSuperColumn(int idx, Serializer<C2> colSer) {
        ColumnOrSuperColumn column = this.columns.get(idx);
        if (column == null) {
            return null;
        }
        if (column.isSetSuper_column()) {
            SuperColumn sc = column.getSuper_column();
            return new ThriftSuperColumnImpl<Object>(colSer.fromBytes(sc.getName()), sc);
        }
        if (column.isSetCounter_super_column()) {
            CounterSuperColumn sc = column.getCounter_super_column();
            return new ThriftCounterSuperColumnImpl<Object>(colSer.fromBytes(sc.getName()), sc);
        }
        throw new UnsupportedOperationException("'" + idx + "' is not a super column");
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public int size() {
        return this.columns.size();
    }

    public boolean isSuperColumn() {
        if (this.columns.isEmpty()) {
            return false;
        }
        ColumnOrSuperColumn sosc = this.columns.get(0);
        return sosc.isSetSuper_column() || sosc.isSetCounter_super_column();
    }

    private ColumnOrSuperColumn getColumn(C columnName) {
        this.constructMap();
        return this.lookup.get(columnName);
    }

    private void constructMap() {
        if (this.lookup == null) {
            this.lookup = Maps.newHashMap();
            for (ColumnOrSuperColumn column : this.columns) {
                if (column.isSetSuper_column()) {
                    this.lookup.put(this.colSer.fromBytes(column.getSuper_column().getName()), column);
                    continue;
                }
                if (column.isSetColumn()) {
                    this.lookup.put(this.colSer.fromBytes(column.getColumn().getName()), column);
                    continue;
                }
                if (column.isSetCounter_column()) {
                    this.lookup.put(this.colSer.fromBytes(column.getCounter_column().getName()), column);
                    continue;
                }
                if (column.isSetCounter_super_column()) {
                    this.lookup.put(this.colSer.fromBytes(column.getCounter_super_column().getName()), column);
                    continue;
                }
                throw new UnsupportedOperationException("Unknown column type");
            }
        }
    }

    public Collection<C> getColumnNames() {
        this.constructMap();
        return this.lookup.keySet();
    }
}

