/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.AbstractColumnImpl;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.thrift.model.ThriftCounterColumnListImpl;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.CounterSuperColumn;

public class ThriftCounterSuperColumnImpl<C>
extends AbstractColumnImpl<C> {
    private final CounterSuperColumn column;

    public ThriftCounterSuperColumnImpl(C name, CounterSuperColumn column) {
        super(name);
        this.column = column;
    }

    public <V> V getValue(Serializer<V> valSer) {
        throw new UnsupportedOperationException("CounterSuperColumn '" + this.getName() + "' has no value");
    }

    public <C2> ColumnList<C2> getSubColumns(Serializer<C2> ser) {
        return new ThriftCounterColumnListImpl<C2>(this.column.getColumns(), ser);
    }

    public boolean isParentColumn() {
        return true;
    }

    public long getTimestamp() {
        throw new UnsupportedOperationException("CounterSuperColumn '" + this.getName() + "' has no timestamp");
    }

    public ByteBuffer getRawName() {
        return ByteBuffer.wrap(this.column.getName());
    }

    public int getTtl() {
        throw new UnsupportedOperationException("CounterSuperColumn '" + this.getName() + "' has no ttl");
    }

    public boolean hasValue() {
        return false;
    }
}

