/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.model.Row;
import com.netflix.astyanax.model.Rows;
import com.netflix.astyanax.thrift.model.ThriftColumnOrSuperColumnListImpl;
import com.netflix.astyanax.thrift.model.ThriftRowImpl;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.thrift.KeySlice;

public class ThriftRowsSliceImpl<K, C>
implements Rows<K, C> {
    private List<Row<K, C>> rows;
    private Map<K, Row<K, C>> lookup;

    public ThriftRowsSliceImpl(List<KeySlice> rows, Serializer<K> keySer, Serializer<C> colSer) {
        this.rows = Lists.newArrayListWithCapacity((int)rows.size());
        for (KeySlice row : rows) {
            ThriftRowImpl<Object, C> thriftRow = new ThriftRowImpl<Object, C>(keySer.fromBytes(row.getKey()), ByteBuffer.wrap(row.getKey()), new ThriftColumnOrSuperColumnListImpl<C>(row.getColumns(), colSer));
            this.rows.add(thriftRow);
        }
    }

    public Iterator<Row<K, C>> iterator() {
        return this.rows.iterator();
    }

    public Row<K, C> getRow(K key) {
        this.lazyBuildLookup();
        return this.lookup.get(key);
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public Row<K, C> getRowByIndex(int index) {
        return this.rows.get(index);
    }

    public Collection<K> getKeys() {
        return Lists.transform(this.rows, (Function)new Function<Row<K, C>, K>(){

            public K apply(Row<K, C> row) {
                return row.getKey();
            }
        });
    }

    private void lazyBuildLookup() {
        if (this.lookup == null) {
            this.lookup = Maps.newHashMap();
            for (Row<K, C> row : this.rows) {
                this.lookup.put(row.getKey(), row);
            }
        }
    }
}

