package org.gcube.spatial.data.clients.geoserver;

import java.util.List;

//import org.apache.commons.httpclient.NameValuePair;
//import org.gcube.application.geoportal.service.engine.RESTFeatureType;
//import org.gcube.application.geoportal.service.engine.RESTLayer;
import org.gcube.spatial.data.sdi.model.faults.RemoteException;
import org.json.simple.JSONObject;

//import it.geosolutions.geoserver.rest.GeoServerRESTPublisher.UploadMethod;
//import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder.ProjectionPolicy;

public interface GSRESTClient {

	
	// Management
	public boolean exist();
	
	
	
	
	// ********** READ OPS 
	
	// WS
	
	public JSONObject getWorkspaces()throws RemoteException,Exception;
	public List<String> getWorkspaceNames()throws RemoteException,Exception;
	public JSONObject getWorkspace(String workspace)throws RemoteException, Exception;
	
	// DS
	public JSONObject getDataStoresInWorkspace(String ws)throws RemoteException,Exception;
	public List<String> getDataStoresNamesInWorkspace(String ws)throws RemoteException,Exception;
	public JSONObject getDataStore(String workspace,String dsName)throws RemoteException,Exception;
	
	
	
	// SLD
	public JSONObject getStyles()throws RemoteException,Exception;
	public List<String> getStylesNames()throws RemoteException,Exception;
	public JSONObject getStylesInWorkspace(String ws)throws RemoteException,Exception;
	public List<String> getStylesNamesinWorkspace(String ws)throws RemoteException,Exception;
	public JSONObject getStylesByLayer(String layer)throws RemoteException,Exception;
	public List<String> getStylesNamesByLayer(String layer)throws RemoteException,Exception;
	public String getSLD(String styleName)throws RemoteException,Exception;
	
	
	// FeatureTypes
//	public JSONObject getFeatureType(JSONObject layer)
	/**
	 * RESTLayer l=reader.getLayer(workspace, toSetLayerName);
			RESTFeatureType f= reader.getFeatureType(l);
	 * @param ws
	 * @throws RemoteException
	 * @throws Exception
	 */
	
	// *********** CREATE OPS
	public void createWorkspace(String ws)throws RemoteException,Exception;
//	
//	public void createStyle(String name,String content)throws RemoteException,Exception;
//	public void createStyle(String name,InputStream content)throws RemoteException,Exception;
//	
	// publish DB layer
	// publish local files
	
	// create store for postgis db
	/**
	 * getDataStoreManager().create(workspace, encoder)
	 */
	
	/**
	 * if(!gis.getCurrentGeoServer().getPublisher().publishStyle(sldFile, name)
	 * 
	 */
	
	
	/**
	 * 
	 * gis.getCurrentGeoServer().getPublisher().publishDBLayer(workspace, storeName, fte, layerEncoder))
	 */
	
	
	/**
	 *  public boolean publishShp(String workspace, String storeName, NameValuePair[] storeParams,
            String datasetName, UploadMethod method, URI shapefile, String srs, String defaultStyle)
            throws FileNotFoundException, IllegalArgumentException {
        return publishShp(workspace, storeName, storeParams, datasetName, method, shapefile, srs,
                null, ProjectionPolicy.FORCE_DECLARED, defaultStyle);
    }
	 * @param ws
	 * @throws RemoteException
	 * @throws Exception
	 */
	
	
//	// +********** DELETE OPS 
	
	/**
	 * publisher.removeWorkspace(toDelete.getWorkspace(), true);
	 * @param ws
	 * @throws RemoteException
	 * @throws Exception
	 */
	public void deleteWorkspace(String ws)throws RemoteException,Exception;
	public void deleteStyle(String style)throws RemoteException,Exception;
	
	
	/**
	 * publisher.removeDatastore(toDelete.getWorkspace(), toDelete.getStore(), true);
	 * @param ds
	 * @throws RemoteException
	 * @throws Exception
	 */
	public void deleteDataStore(String ds)throws RemoteException,Exception;
	public void deleteLayer(String layer)throws RemoteException,Exception;
}
