/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis;

import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geoserver.rest.GeoServerRESTManager;
import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.gis.ResearchMethod;
import org.gcube.spatial.data.gis.is.GeoServerDescriptor;
import org.gcube.spatial.data.gis.is.InfrastructureCrawler;
import org.gcube.spatial.data.gis.meta.MetadataEnricher;
import org.gcube.spatial.data.gis.model.report.DeleteReport;
import org.gcube.spatial.data.gis.model.report.PublishResponse;
import org.gcube.spatial.data.gis.model.report.Report;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GISInterface {
    static final Logger logger = LoggerFactory.getLogger(GISInterface.class);
    private static final long MAX_GEOSERVER_CACHE_TIME = 120000L;
    private GeoNetworkPublisher geoNetwork = null;
    private ConcurrentSkipListSet<GeoServerDescriptor> geoservers = new ConcurrentSkipListSet();
    private long lastAccessedTime = 0L;

    public static GISInterface get() throws Exception {
        return new GISInterface();
    }

    private GISInterface() throws Exception {
    }

    public GeoNetworkReader getGeoNetworkReader() throws Exception {
        return this.getGN();
    }

    public GeoNetworkPublisher getGeoNewtorkPublisher() throws Exception {
        return this.getGN();
    }

    public GeoServerRESTReader getGeoServerReader(ResearchMethod method, boolean forceRefresh) throws Exception {
        GeoServerDescriptor desc = this.getGeoServerSet(forceRefresh).last();
        return this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getReader();
    }

    public GeoServerRESTReader getGeoServerReader(String url, String user, String password) throws IllegalArgumentException, MalformedURLException {
        return this.getGeoServerManager(url, user, password).getReader();
    }

    public GeoServerRESTReader getGeoServerReader(String url) throws MalformedURLException {
        return new GeoServerRESTReader(url);
    }

    public PublishResponse addGeoTIFF(String workspace, String storeName, String coverageName, File toPublishFile, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox, Metadata geoNetworkMeta, GNInsertConfiguration config, LoginLevel level) {
        PublishResponse toReturn;
        block11: {
            boolean publishResult = false;
            toReturn = new PublishResponse(geoNetworkMeta);
            GeoServerRESTPublisher publisher = null;
            GeoServerDescriptor desc = this.getGeoServerSet(false).last();
            logger.debug("Using " + desc);
            try {
                publisher = this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getPublisher();
                publishResult = publisher.publishGeoTIFF(workspace, storeName, coverageName, toPublishFile, srs, policy, defaultStyle, bbox);
                if (publishResult) {
                    toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                    ArrayList<String> distributionUris = new ArrayList<String>();
                    MetadataEnricher enricher = new MetadataEnricher(geoNetworkMeta, true);
                    enricher.addDate(new Date(System.currentTimeMillis()), DateType.CREATION);
                    enricher.addPreview((String)distributionUris.get(0));
                    enricher.setdistributionURIs(distributionUris);
                    toReturn.getMetaOperationMessages().addAll(enricher.getMessages());
                    if (enricher.getMessages().size() > 0) {
                        toReturn.setMetaOperationResult(Report.OperationState.WARN);
                    }
                    GeoNetworkPublisher pub = this.getGN();
                    this.getGN().login(level);
                    long returnedId = pub.insertMetadata(config, (Metadata)enricher.getEnriched());
                    toReturn.setReturnedMetaId(returnedId);
                    toReturn.setMetaOperationResult(Report.OperationState.COMPLETE);
                } else {
                    toReturn.getDataOperationMessages().add("Publish operation returned false, unable to publish data");
                }
            }
            catch (NoSuchElementException e) {
                toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeProvider.instance.get());
            }
            catch (IllegalArgumentException e) {
                if (publisher == null) {
                    toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                } else {
                    toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
                }
            }
            catch (MalformedURLException e) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
            }
            catch (Exception e) {
                toReturn.getMetaOperationMessages().add("Unable to publish metadata, cause :" + e.getMessage());
                DeleteReport delRep = this.deleteStore(workspace, storeName, null, desc);
                if (delRep.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE)) break block11;
                toReturn.setDataOperationResult(Report.OperationState.WARN);
                toReturn.getDataOperationMessages().add("Unable to rollback data publishing, following messages from delete operation (state : " + (Object)((Object)delRep.getDataOperationResult()) + ")");
                toReturn.getDataOperationMessages().addAll(delRep.getDataOperationMessages());
            }
        }
        return toReturn;
    }

    public PublishResponse publishDBTable(String workspace, String storeName, GSFeatureTypeEncoder fte, GSLayerEncoder layerEncoder, Metadata geoNetworkMeta, GNInsertConfiguration config, LoginLevel level) {
        PublishResponse toReturn;
        block11: {
            boolean publishResult = false;
            toReturn = new PublishResponse(geoNetworkMeta);
            GeoServerRESTPublisher publisher = null;
            GeoServerDescriptor desc = this.getGeoServerSet(false).last();
            logger.debug("Using " + desc);
            try {
                publisher = this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getPublisher();
                publishResult = publisher.publishDBLayer(workspace, storeName, fte, layerEncoder);
                if (publishResult) {
                    toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                    ArrayList<String> distributionUris = new ArrayList<String>();
                    MetadataEnricher enricher = new MetadataEnricher(geoNetworkMeta, true);
                    enricher.addDate(new Date(System.currentTimeMillis()), DateType.CREATION);
                    enricher.addPreview((String)distributionUris.get(0));
                    enricher.setdistributionURIs(distributionUris);
                    toReturn.getMetaOperationMessages().addAll(enricher.getMessages());
                    if (enricher.getMessages().size() > 0) {
                        toReturn.setMetaOperationResult(Report.OperationState.WARN);
                    }
                    GeoNetworkPublisher pub = this.getGN();
                    this.getGN().login(level);
                    long returnedId = pub.insertMetadata(config, (Metadata)enricher.getEnriched());
                    toReturn.setReturnedMetaId(returnedId);
                    toReturn.setMetaOperationResult(Report.OperationState.COMPLETE);
                } else {
                    toReturn.getDataOperationMessages().add("Publish operation returned false, unable to publish data");
                }
            }
            catch (NoSuchElementException e) {
                toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeProvider.instance.get());
            }
            catch (IllegalArgumentException e) {
                if (publisher == null) {
                    toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                } else {
                    toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
                }
            }
            catch (MalformedURLException e) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
            }
            catch (Exception e) {
                toReturn.getMetaOperationMessages().add("Unable to publish metadata, cause :" + e.getMessage());
                DeleteReport delRep = this.deleteLayer(workspace, fte.getName(), null, desc);
                if (delRep.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE)) break block11;
                toReturn.setDataOperationResult(Report.OperationState.WARN);
                toReturn.getDataOperationMessages().add("Unable to rollback data publishing, following messages from delete operation (state : " + (Object)((Object)delRep.getDataOperationResult()) + ")");
                toReturn.getDataOperationMessages().addAll(delRep.getDataOperationMessages());
            }
        }
        return toReturn;
    }

    public PublishResponse publishStyle(String sldBody, String styleName) {
        PublishResponse toReturn;
        block9: {
            boolean publishResult = false;
            toReturn = new PublishResponse();
            GeoServerRESTPublisher publisher = null;
            GeoServerDescriptor desc = this.getGeoServerSet(false).last();
            logger.debug("Using " + desc);
            try {
                publisher = this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getPublisher();
                publishResult = publisher.publishStyle(sldBody, styleName);
                if (publishResult) {
                    toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                } else {
                    toReturn.getDataOperationMessages().add("Publish operation returned false, unable to publish data");
                }
            }
            catch (NoSuchElementException e) {
                toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeProvider.instance.get());
            }
            catch (IllegalArgumentException e) {
                if (publisher == null) {
                    toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                } else {
                    toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
                }
            }
            catch (MalformedURLException e) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            }
            catch (Exception e) {
                toReturn.getMetaOperationMessages().add("Unable to publish metadata, cause :" + e.getMessage());
                DeleteReport delRep = this.deleteStyle(styleName, desc);
                if (delRep.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE)) break block9;
                toReturn.setDataOperationResult(Report.OperationState.WARN);
                toReturn.getDataOperationMessages().add("Unable to rollback data publishing, following messages from delete operation (state : " + (Object)((Object)delRep.getDataOperationResult()) + ")");
                toReturn.getDataOperationMessages().addAll(delRep.getDataOperationMessages());
            }
        }
        return toReturn;
    }

    public DeleteReport deleteStore(String workspace, String storeName, Long metadataUUID, GeoServerDescriptor desc) {
        DeleteReport toReturn = new DeleteReport();
        GeoServerRESTPublisher publisher = null;
        try {
            publisher = this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getPublisher();
            boolean removed = publisher.removeDatastore(workspace, storeName, true);
            if (removed) {
                toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                if (metadataUUID != null) {
                    this.getGN().deleteMetadata(metadataUUID.longValue());
                } else {
                    toReturn.setMetaOperationResult(Report.OperationState.WARN);
                    toReturn.getMetaOperationMessages().add("Passed meta UUID is null, no metadata deleted");
                }
            } else {
                toReturn.getDataOperationMessages().add("Remove data operation returned false, unable to delete Store");
            }
        }
        catch (NoSuchElementException e) {
            toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeProvider.instance.get());
        }
        catch (IllegalArgumentException e) {
            if (publisher == null) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            } else {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
        }
        catch (Exception e) {
            toReturn.getMetaOperationMessages().add("Unable to delete metadata, cause :" + e.getMessage());
        }
        return toReturn;
    }

    public DeleteReport deleteLayer(String workspace, String layerName, Long metadataUUID, GeoServerDescriptor desc) {
        DeleteReport toReturn = new DeleteReport();
        GeoServerRESTPublisher publisher = null;
        try {
            publisher = this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getPublisher();
            boolean removed = publisher.removeLayer(workspace, layerName);
            if (removed) {
                toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                if (metadataUUID != null) {
                    this.getGN().deleteMetadata(metadataUUID.longValue());
                } else {
                    toReturn.setMetaOperationResult(Report.OperationState.WARN);
                    toReturn.getMetaOperationMessages().add("Passed meta UUID is null, no metadata deleted");
                }
            } else {
                toReturn.getDataOperationMessages().add("Remove data operation returned false, unable to delete Store");
            }
        }
        catch (NoSuchElementException e) {
            toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeProvider.instance.get());
        }
        catch (IllegalArgumentException e) {
            if (publisher == null) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            } else {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
        }
        catch (Exception e) {
            toReturn.getMetaOperationMessages().add("Unable to delete metadata, cause :" + e.getMessage());
        }
        return toReturn;
    }

    public DeleteReport deleteStyle(String styleName, GeoServerDescriptor desc) {
        DeleteReport toReturn = new DeleteReport();
        GeoServerRESTPublisher publisher = null;
        try {
            publisher = this.getGeoServerManager(desc.getUrl(), desc.getUser(), desc.getPassword()).getPublisher();
            boolean removed = publisher.removeStyle(styleName, true);
            if (removed) {
                toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
            } else {
                toReturn.getDataOperationMessages().add("Remove data operation returned false, unable to delete Store");
            }
        }
        catch (NoSuchElementException e) {
            toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeProvider.instance.get());
        }
        catch (IllegalArgumentException e) {
            if (publisher == null) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            } else {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
        }
        catch (Exception e) {
            toReturn.getMetaOperationMessages().add("Unable to delete metadata, cause :" + e.getMessage());
        }
        return toReturn;
    }

    private synchronized SortedSet<GeoServerDescriptor> getGeoServerSet(boolean forceRefresh) {
        if (forceRefresh || this.geoservers.size() == 0 || System.currentTimeMillis() - this.lastAccessedTime > 120000L) {
            this.geoservers.clear();
            this.geoservers.addAll(InfrastructureCrawler.queryforGeoServer());
            this.lastAccessedTime = System.currentTimeMillis();
        }
        return this.geoservers;
    }

    private synchronized GeoNetworkPublisher getGN() throws Exception {
        if (this.geoNetwork == null) {
            this.geoNetwork = GeoNetwork.get();
        }
        return this.geoNetwork;
    }

    private GeoServerRESTManager getGeoServerManager(String url, String user, String password) throws IllegalArgumentException, MalformedURLException {
        return new GeoServerRESTManager(new URL(url), user, password);
    }
}

