/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis.wms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gcube.spatial.data.gis.wms.WmsParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmsRequestValidator {
    private HashMap<String, String> parametersValue = new HashMap();
    private String wmsRequest;
    private String baseWmsServiceUrl;
    private String wmsParameters;
    private String wmsNotStandardParameters = "";
    private Map<String, String> mapWmsNotStandardParams;
    public static Logger logger = LoggerFactory.getLogger(WmsRequestValidator.class);

    public WmsRequestValidator(String wmsRequest) {
        this.wmsRequest = wmsRequest;
        int indexStart = wmsRequest.indexOf("?");
        if (indexStart == -1) {
            this.baseWmsServiceUrl = wmsRequest;
            this.wmsParameters = null;
        } else {
            this.baseWmsServiceUrl = wmsRequest.substring(0, indexStart);
            this.baseWmsServiceUrl.trim();
            this.wmsParameters = wmsRequest.substring(indexStart + 1, this.wmsRequest.length());
            this.wmsParameters.trim();
        }
    }

    public String parseWmsRequest(boolean returnEmptyParameter, boolean fillEmptyParameterAsDefaultValue) throws Exception {
        if (this.wmsParameters == null || this.wmsParameters.isEmpty()) {
            String msg = "IT IS NOT POSSIBLE TO PARSE WMS URL, 'WMS PARAMETERS' not found!";
            throw new Exception(msg);
        }
        for (WmsParameters wmsParam : WmsParameters.values()) {
            String value;
            if (wmsParam.equals((Object)WmsParameters.BBOX)) {
                value = WmsRequestValidator.validateValueOfParameter(WmsParameters.BBOX, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), value);
            }
            if (wmsParam.equals((Object)WmsParameters.FORMAT)) {
                value = WmsRequestValidator.validateValueOfParameter(WmsParameters.FORMAT, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), value);
            }
            if (wmsParam.equals((Object)WmsParameters.HEIGHT)) {
                value = WmsRequestValidator.validateValueOfParameter(WmsParameters.HEIGHT, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), value);
            }
            if (wmsParam.equals((Object)WmsParameters.CRS)) {
                String crs = WmsRequestValidator.validateValueOfParameter(WmsParameters.CRS, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), crs);
            }
            if (wmsParam.equals((Object)WmsParameters.WIDTH)) {
                value = WmsRequestValidator.validateValueOfParameter(WmsParameters.WIDTH, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), value);
            }
            if (wmsParam.equals((Object)WmsParameters.REQUEST)) {
                value = WmsRequestValidator.validateValueOfParameter(WmsParameters.REQUEST, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), value);
            }
            if (wmsParam.equals((Object)WmsParameters.SERVICE)) {
                value = WmsRequestValidator.validateValueOfParameter(WmsParameters.SERVICE, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), value);
            }
            if (wmsParam.equals((Object)WmsParameters.SRS)) {
                value = WmsRequestValidator.validateValueOfParameter(WmsParameters.SRS, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), value);
            }
            if (wmsParam.equals((Object)WmsParameters.STYLES)) {
                String styles = WmsRequestValidator.validateValueOfParameter(WmsParameters.STYLES, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), styles);
            }
            if (wmsParam.equals((Object)WmsParameters.VERSION)) {
                String version = WmsRequestValidator.validateValueOfParameter(WmsParameters.VERSION, this.wmsParameters, fillEmptyParameterAsDefaultValue);
                this.parametersValue.put(wmsParam.getParameter(), version);
            }
            if (!wmsParam.equals((Object)WmsParameters.LAYERS)) continue;
            String layers = WmsRequestValidator.validateValueOfParameter(WmsParameters.LAYERS, this.wmsParameters, fillEmptyParameterAsDefaultValue);
            this.parametersValue.put(wmsParam.getParameter(), layers);
        }
        String parsedWmsRequest = this.baseWmsServiceUrl + "?";
        String[] params = this.wmsParameters.split("&");
        this.mapWmsNotStandardParams = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String param : params) {
            String key = param.substring(0, param.indexOf("="));
            String value = param.substring(param.indexOf("=") + 1, param.length());
            this.mapWmsNotStandardParams.put(key, value);
        }
        for (String key : this.parametersValue.keySet()) {
            String value = this.parametersValue.get(key);
            if (returnEmptyParameter && value.isEmpty()) {
                parsedWmsRequest = parsedWmsRequest + key + "=" + value;
                continue;
            }
            parsedWmsRequest = parsedWmsRequest + key + "=" + value;
            parsedWmsRequest = parsedWmsRequest + "&";
            String exist = this.mapWmsNotStandardParams.get(key);
            if (exist == null) continue;
            this.mapWmsNotStandardParams.remove(key);
        }
        for (String key : this.mapWmsNotStandardParams.keySet()) {
            this.wmsNotStandardParameters = this.wmsNotStandardParameters + key + "=" + this.mapWmsNotStandardParams.get(key) + "&";
        }
        if (this.wmsNotStandardParameters.length() > 0) {
            this.wmsNotStandardParameters = this.wmsNotStandardParameters.substring(0, this.wmsNotStandardParameters.length() - 1);
        }
        String fullWmsUrlBuilded = !this.wmsNotStandardParameters.isEmpty() ? parsedWmsRequest + this.wmsNotStandardParameters : parsedWmsRequest.substring(0, parsedWmsRequest.length() - 1);
        return fullWmsUrlBuilded;
    }

    public String getWmsRequest() {
        return this.wmsRequest;
    }

    public String getBaseWmsServiceUrl() {
        return this.baseWmsServiceUrl;
    }

    public String getWmsNotStandardParameters() {
        return this.wmsNotStandardParameters;
    }

    public String getValueOfParsedWMSParameter(WmsParameters parameter) {
        return this.parametersValue.get(parameter.getParameter());
    }

    public static String validateValueOfParameter(WmsParameters wmsParam, String valueOfParameter, boolean fillEmptyParameterAsDefaultValue) {
        String value = WmsRequestValidator.getValueOfParameter(wmsParam, valueOfParameter);
        if (fillEmptyParameterAsDefaultValue && (value == null || value.isEmpty())) {
            value = wmsParam.getValue();
        }
        return value;
    }

    public static String getValueOfParameter(WmsParameters wmsParam, String wmsUrlParameters) {
        logger.trace("getValueOfParameter: " + (Object)((Object)wmsParam) + " into " + wmsUrlParameters);
        int index = wmsUrlParameters.toLowerCase().indexOf(wmsParam.getParameter().toLowerCase());
        String value = "";
        if (index > -1) {
            int start = index + wmsParam.getParameter().length() + 1;
            String sub = wmsUrlParameters.substring(start, wmsUrlParameters.length());
            int indexOfSeparator = sub.indexOf("&");
            int end = indexOfSeparator != -1 ? indexOfSeparator : sub.length();
            value = sub.substring(0, end);
        }
        logger.trace("returning value: " + value);
        return value;
    }

    public static String setValueOfParameter(WmsParameters wmsParam, String wmsUrlParameters, String newValue, boolean addIfNotExists) {
        logger.trace("setValueOfParameter: " + (Object)((Object)wmsParam) + " into " + wmsUrlParameters);
        String toLowerWmsUrlParameters = wmsUrlParameters.toLowerCase();
        String toLowerWmsParam = wmsParam.getParameter().toLowerCase();
        int index = toLowerWmsUrlParameters.indexOf(toLowerWmsParam + "=");
        if (index > -1) {
            int indexStartValue = index + toLowerWmsParam.length() + 1;
            int indexOfSeparator = toLowerWmsUrlParameters.indexOf("&", indexStartValue);
            int indexEndValue = indexOfSeparator != -1 ? indexOfSeparator : toLowerWmsUrlParameters.length();
            return wmsUrlParameters.substring(0, indexStartValue) + newValue + wmsUrlParameters.substring(indexEndValue, wmsUrlParameters.length());
        }
        if (addIfNotExists) {
            wmsUrlParameters = wmsUrlParameters + "&" + wmsParam.getParameter() + "=" + newValue;
        }
        logger.trace("returning value: " + wmsUrlParameters);
        return wmsUrlParameters;
    }

    public List<String> getStylesAsList() {
        ArrayList<String> listStyles = new ArrayList<String>();
        String styles = this.getValueOfParsedWMSParameter(WmsParameters.STYLES);
        if (styles != null && !styles.isEmpty()) {
            String[] arrayStyle;
            for (String style : arrayStyle = styles.split(",")) {
                if (style == null || style.isEmpty()) continue;
                listStyles.add(style);
            }
        }
        return listStyles;
    }

    public Map<String, String> getMapWmsNotStandardParams() {
        return this.mapWmsNotStandardParams;
    }
}

