/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.gis;

import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geoserver.rest.GeoServerRESTPublisher;
import it.geosolutions.geoserver.rest.GeoServerRESTReader;
import it.geosolutions.geoserver.rest.encoder.GSAbstractStoreEncoder;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.GSResourceEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.XMLAdapter;
import org.gcube.spatial.data.geonetwork.iso.BoundingBox;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.gis.ResearchMethod;
import org.gcube.spatial.data.gis.URIUtils;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.gcube.spatial.data.gis.is.GeoServerDescriptor;
import org.gcube.spatial.data.gis.is.cache.ExplicitCache;
import org.gcube.spatial.data.gis.is.cache.GeoServerCache;
import org.gcube.spatial.data.gis.is.cache.ISGeoServerCache;
import org.gcube.spatial.data.gis.meta.MetadataEnricher;
import org.gcube.spatial.data.gis.model.report.DeleteReport;
import org.gcube.spatial.data.gis.model.report.PublishResponse;
import org.gcube.spatial.data.gis.model.report.Report;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.DateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GISInterface {
    private static final Logger log = LoggerFactory.getLogger(GISInterface.class);
    private List<XMLAdapter> toRegisterXMLAdapters = null;
    private GeoServerCache theActualCache;
    private GeoNetworkPublisher geoNetwork = null;

    public static GISInterface get(AbstractGeoServerDescriptor ... descriptors) throws Exception {
        if (descriptors != null && descriptors.length > 0) {
            return new GISInterface(Arrays.asList(descriptors));
        }
        return new GISInterface();
    }

    private GISInterface() throws Exception {
        this.theActualCache = new ISGeoServerCache();
    }

    private <T extends AbstractGeoServerDescriptor> GISInterface(Collection<T> collection) {
        this.theActualCache = new ExplicitCache<T>(collection);
    }

    public void setToRegisterXMLAdapters(List<XMLAdapter> toRegisterXMLAdapters) {
        this.toRegisterXMLAdapters = toRegisterXMLAdapters;
    }

    public GeoNetworkReader getGeoNetworkReader() throws Exception {
        return this.getGN();
    }

    public GeoNetworkPublisher getGeoNewtorkPublisher() throws Exception {
        return this.getGN();
    }

    public PublishResponse addGeoTIFF(String workspace, String storeName, String coverageName, File toPublishFile, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox, Metadata geoNetworkMeta, String gnCategory, String gnStylesheet, LoginLevel level, boolean promoteMetadataPublishing) {
        try {
            GeoNetworkPublisher gn = this.getGN();
            gn.login(level);
            GNInsertConfiguration config = gn.getCurrentUserConfiguration(gnCategory, gnStylesheet);
            return this.addGeoTIFF(workspace, storeName, coverageName, toPublishFile, srs, policy, defaultStyle, bbox, geoNetworkMeta, config, level, promoteMetadataPublishing);
        }
        catch (Exception e) {
            PublishResponse response = new PublishResponse(geoNetworkMeta);
            response.getMetaOperationMessages().add("Unable to get GN Configuration , cause :" + e.getMessage());
            return response;
        }
    }

    public PublishResponse publishDBTable(String workspace, String storeName, GSFeatureTypeEncoder fte, GSLayerEncoder layerEncoder, Metadata geoNetworkMeta, String gnCategory, String gnStylesheet, LoginLevel level, boolean promoteMetadataPublishing) {
        try {
            GeoNetworkPublisher gn = this.getGN();
            gn.login(level);
            GNInsertConfiguration config = gn.getCurrentUserConfiguration(gnCategory, gnStylesheet);
            return this.publishDBTable(workspace, storeName, fte, layerEncoder, geoNetworkMeta, config, level, promoteMetadataPublishing);
        }
        catch (Exception e) {
            PublishResponse response = new PublishResponse(geoNetworkMeta);
            response.getMetaOperationMessages().add("Unable to get GN Configuration , cause :" + e.getMessage());
            return response;
        }
    }

    @Deprecated
    public PublishResponse addGeoTIFF(String workspace, String storeName, String coverageName, File toPublishFile, String srs, GSResourceEncoder.ProjectionPolicy policy, String defaultStyle, double[] bbox, Metadata geoNetworkMeta, GNInsertConfiguration config, LoginLevel level, boolean promoteMetadataPublishing) {
        PublishResponse toReturn;
        block12: {
            boolean publishResult = false;
            toReturn = new PublishResponse(geoNetworkMeta);
            GeoServerRESTPublisher publisher = null;
            Object desc = this.getCache().getDefaultDescriptor();
            log.debug("Using " + desc);
            try {
                publisher = ((AbstractGeoServerDescriptor)desc).getPublisher();
                publishResult = publisher.publishGeoTIFF(workspace, storeName, coverageName, toPublishFile, srs, policy, defaultStyle, bbox);
                if (publishResult) {
                    ((AbstractGeoServerDescriptor)desc).onChangedLayers();
                    toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                    MetadataEnricher enricher = new MetadataEnricher(geoNetworkMeta, true);
                    ArrayList<String> distributionUris = new ArrayList<String>();
                    distributionUris.add(URIUtils.getWmsUrl(((AbstractGeoServerDescriptor)desc).getUrl(), coverageName, defaultStyle, new BoundingBox(Double.valueOf(bbox[0]), Double.valueOf(bbox[1]), Double.valueOf(bbox[2]), Double.valueOf(bbox[3]))));
                    distributionUris.add(URIUtils.getWfsUrl(((AbstractGeoServerDescriptor)desc).getUrl(), coverageName));
                    distributionUris.add(URIUtils.getWcsUrl(((AbstractGeoServerDescriptor)desc).getUrl(), coverageName, new BoundingBox(Double.valueOf(bbox[0]), Double.valueOf(bbox[1]), Double.valueOf(bbox[2]), Double.valueOf(bbox[3]))));
                    try {
                        distributionUris.add(URIUtils.getGisLinkByUUID(enricher.getMetadataIdentifier()));
                    }
                    catch (Exception e) {
                        log.warn("Unabel to get Gis Link ", (Throwable)e);
                        toReturn.setMetaOperationResult(Report.OperationState.WARN);
                        toReturn.getMetaOperationMessages().add("Unable to generate GIS link, cause : " + e.getMessage());
                    }
                    enricher.addDate(new Date(System.currentTimeMillis()), DateType.CREATION);
                    enricher.addPreview((String)distributionUris.get(0));
                    enricher.setdistributionURIs(distributionUris, coverageName);
                    toReturn.getMetaOperationMessages().addAll(enricher.getMessages());
                    if (enricher.getMessages().size() > 0) {
                        toReturn.setMetaOperationResult(Report.OperationState.WARN);
                    }
                    GeoNetworkPublisher pub = this.getGN();
                    this.getGN().login(level);
                    DefaultMetadata enriched = enricher.getEnriched();
                    toReturn.setPublishedMetadata((Metadata)enriched);
                    long returnedId = promoteMetadataPublishing ? pub.insertAndPromoteMetadata(config, (Metadata)enriched) : pub.insertMetadata(config, (Metadata)enriched);
                    toReturn.setReturnedMetaId(returnedId);
                    toReturn.setMetaOperationResult(Report.OperationState.COMPLETE);
                    break block12;
                }
                toReturn.getDataOperationMessages().add("Publish operation returned false, unable to publish data");
            }
            catch (NoSuchElementException e) {
                toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeUtils.getCurrentScope());
            }
            catch (IllegalArgumentException e) {
                if (publisher == null) {
                    toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                    log.debug("Unable to instatiate GeoServerRESTPublisher", (Throwable)e);
                } else {
                    toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
                    log.debug("Unable to publish data", (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                log.debug("Unable to instatiate GeoServerRESTPublisher", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
                log.debug("Unable to publish data", (Throwable)e);
            }
            catch (Exception e) {
                toReturn.getMetaOperationMessages().add("Unable to publish metadata, cause :" + e.getMessage());
                log.debug("Unable to publish metadata", (Throwable)e);
                DeleteReport delRep = this.deleteStore(workspace, storeName, null, (AbstractGeoServerDescriptor)desc);
                if (delRep.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE)) break block12;
                toReturn.setDataOperationResult(Report.OperationState.WARN);
                toReturn.getDataOperationMessages().add("Unable to rollback data publishing, following messages from delete operation (state : " + (Object)((Object)delRep.getDataOperationResult()) + ")");
                toReturn.getDataOperationMessages().addAll(delRep.getDataOperationMessages());
            }
        }
        return toReturn;
    }

    @Deprecated
    public PublishResponse publishDBTable(String workspace, String storeName, GSFeatureTypeEncoder fte, GSLayerEncoder layerEncoder, Metadata geoNetworkMeta, GNInsertConfiguration config, LoginLevel level, boolean promoteMetadataPublishing) {
        PublishResponse toReturn;
        block12: {
            boolean publishResult = false;
            toReturn = new PublishResponse(geoNetworkMeta);
            GeoServerRESTPublisher publisher = null;
            Object desc = this.getCache().getDefaultDescriptor();
            log.debug("Publish db table : " + storeName + " under ws : " + workspace + ", using geoserver " + desc);
            log.debug("Using " + desc);
            try {
                publisher = ((AbstractGeoServerDescriptor)desc).getPublisher();
                publishResult = publisher.publishDBLayer(workspace, storeName, fte, layerEncoder);
                if (publishResult) {
                    ((AbstractGeoServerDescriptor)desc).onChangedLayers();
                    toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                    log.debug("Published data, enriching meta..");
                    MetadataEnricher enricher = new MetadataEnricher(geoNetworkMeta, true);
                    ArrayList<String> distributionUris = new ArrayList<String>();
                    distributionUris.add(URIUtils.getWmsUrl(((AbstractGeoServerDescriptor)desc).getUrl(), fte.getName(), URIUtils.getStyleFromGSLayerEncoder(layerEncoder), BoundingBox.WORLD_EXTENT));
                    distributionUris.add(URIUtils.getWfsUrl(((AbstractGeoServerDescriptor)desc).getUrl(), fte.getName()));
                    distributionUris.add(URIUtils.getWcsUrl(((AbstractGeoServerDescriptor)desc).getUrl(), fte.getName(), BoundingBox.WORLD_EXTENT));
                    try {
                        distributionUris.add(URIUtils.getGisLinkByUUID(enricher.getMetadataIdentifier()));
                    }
                    catch (Exception e) {
                        log.warn("Unabel to get Gis Link ", (Throwable)e);
                        toReturn.setMetaOperationResult(Report.OperationState.WARN);
                        toReturn.getMetaOperationMessages().add("Unable to generate GIS link, cause : " + e.getMessage());
                    }
                    enricher.addDate(new Date(System.currentTimeMillis()), DateType.CREATION);
                    enricher.addPreview((String)distributionUris.get(0));
                    enricher.setdistributionURIs(distributionUris, fte.getName());
                    toReturn.getMetaOperationMessages().addAll(enricher.getMessages());
                    if (enricher.getMessages().size() > 0) {
                        toReturn.setMetaOperationResult(Report.OperationState.WARN);
                    }
                    GeoNetworkPublisher pub = this.getGN();
                    this.getGN().login(level);
                    DefaultMetadata enriched = enricher.getEnriched();
                    toReturn.setPublishedMetadata((Metadata)enriched);
                    long returnedId = promoteMetadataPublishing ? pub.insertAndPromoteMetadata(config, (Metadata)enriched) : pub.insertMetadata(config, (Metadata)enriched);
                    toReturn.setReturnedMetaId(returnedId);
                    toReturn.setMetaOperationResult(Report.OperationState.COMPLETE);
                    break block12;
                }
                toReturn.getDataOperationMessages().add("Publish operation returned false, unable to publish data");
            }
            catch (NoSuchElementException e) {
                toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeUtils.getCurrentScope());
            }
            catch (IllegalArgumentException e) {
                if (publisher == null) {
                    toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                    log.debug("Unable to instatiate GeoServerRESTPublisher", (Throwable)e);
                } else {
                    toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
                    log.debug("Unable to publish data", (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                log.debug("Unable to instatiate GeoServerRESTPublisher", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
                log.debug("Unable to publish data", (Throwable)e);
            }
            catch (Exception e) {
                toReturn.getMetaOperationMessages().add("Unable to publish metadata, cause :" + e.getMessage());
                log.debug("Unable to publish metadata", (Throwable)e);
                DeleteReport delRep = this.deleteLayer(workspace, fte.getName(), null, (AbstractGeoServerDescriptor)desc, level);
                if (delRep.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE)) break block12;
                toReturn.setDataOperationResult(Report.OperationState.WARN);
                toReturn.getDataOperationMessages().add("Unable to rollback data publishing, following messages from delete operation (state : " + (Object)((Object)delRep.getDataOperationResult()) + ")");
                toReturn.getDataOperationMessages().addAll(delRep.getDataOperationMessages());
            }
        }
        return toReturn;
    }

    public PublishResponse publishStyle(String sldBody, String styleName) {
        PublishResponse toReturn;
        block9: {
            boolean publishResult = false;
            toReturn = new PublishResponse();
            GeoServerRESTPublisher publisher = null;
            Object desc = this.getCache().getDefaultDescriptor();
            log.debug("Using " + desc);
            try {
                publisher = ((AbstractGeoServerDescriptor)desc).getPublisher();
                publishResult = publisher.publishStyle(sldBody, styleName);
                if (publishResult) {
                    ((AbstractGeoServerDescriptor)desc).onChangedStyles();
                    toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                } else {
                    toReturn.getDataOperationMessages().add("Publish operation returned false, unable to publish data");
                }
            }
            catch (NoSuchElementException e) {
                toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeUtils.getCurrentScope());
            }
            catch (IllegalArgumentException e) {
                if (publisher == null) {
                    toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                    log.debug("Unable to instatiate GeoServerRESTPublisher", (Throwable)e);
                } else {
                    toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
                    log.debug("Unable to publish data", (Throwable)e);
                }
            }
            catch (MalformedURLException e) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
                log.debug("Unable to instatiate GeoServerRESTPublisher", (Throwable)e);
            }
            catch (Exception e) {
                toReturn.getMetaOperationMessages().add("Unable to publish metadata, cause :" + e.getMessage());
                log.debug("Unable to publish metadata", (Throwable)e);
                DeleteReport delRep = this.deleteStyle(styleName, (AbstractGeoServerDescriptor)desc);
                if (delRep.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE)) break block9;
                toReturn.setDataOperationResult(Report.OperationState.WARN);
                toReturn.getDataOperationMessages().add("Unable to rollback data publishing, following messages from delete operation (state : " + (Object)((Object)delRep.getDataOperationResult()) + ")");
                toReturn.getDataOperationMessages().addAll(delRep.getDataOperationMessages());
            }
        }
        return toReturn;
    }

    public DeleteReport deleteStore(String workspace, String storeName, Long metadataUUID, AbstractGeoServerDescriptor desc) {
        DeleteReport toReturn = new DeleteReport();
        GeoServerRESTPublisher publisher = null;
        try {
            publisher = desc.getPublisher();
            boolean removed = publisher.removeDatastore(workspace, storeName, true);
            if (removed) {
                desc.onChangedDataStores();
                toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                if (metadataUUID != null) {
                    this.getGN().deleteMetadata(metadataUUID.longValue());
                } else {
                    toReturn.setMetaOperationResult(Report.OperationState.WARN);
                    toReturn.getMetaOperationMessages().add("Passed meta UUID is null, no metadata deleted");
                }
            } else {
                toReturn.getDataOperationMessages().add("Remove data operation returned false, unable to delete Store");
            }
        }
        catch (NoSuchElementException e) {
            toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeUtils.getCurrentScope());
        }
        catch (IllegalArgumentException e) {
            if (publisher == null) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            } else {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
        }
        catch (Exception e) {
            toReturn.getMetaOperationMessages().add("Unable to delete metadata, cause :" + e.getMessage());
        }
        return toReturn;
    }

    public DeleteReport deleteLayer(String workspace, String layerName, Long metadataUUID, AbstractGeoServerDescriptor desc, LoginLevel gnLoginLevel) {
        DeleteReport toReturn = new DeleteReport();
        GeoServerRESTPublisher publisher = null;
        try {
            publisher = desc.getPublisher();
            boolean removed = publisher.removeLayer(workspace, layerName);
            if (removed) {
                desc.onChangedLayers();
                toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
                if (metadataUUID != null) {
                    GeoNetworkPublisher gnPub = this.getGN();
                    gnPub.login(gnLoginLevel);
                    gnPub.deleteMetadata(metadataUUID.longValue());
                } else {
                    toReturn.setMetaOperationResult(Report.OperationState.WARN);
                    toReturn.getMetaOperationMessages().add("Passed meta UUID is null, no metadata deleted");
                }
            } else {
                toReturn.getDataOperationMessages().add("Remove data operation returned false, unable to delete Store");
            }
        }
        catch (NoSuchElementException e) {
            toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeUtils.getCurrentScope());
        }
        catch (IllegalArgumentException e) {
            if (publisher == null) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            } else {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
        }
        catch (Exception e) {
            toReturn.getMetaOperationMessages().add("Unable to delete metadata, cause :" + e.getMessage());
        }
        return toReturn;
    }

    public DeleteReport deleteStyle(String styleName, AbstractGeoServerDescriptor desc) {
        DeleteReport toReturn = new DeleteReport();
        GeoServerRESTPublisher publisher = null;
        try {
            publisher = desc.getPublisher();
            boolean removed = publisher.removeStyle(styleName, true);
            if (removed) {
                desc.onChangedStyles();
                toReturn.setDataOperationResult(Report.OperationState.COMPLETE);
            } else {
                toReturn.getDataOperationMessages().add("Remove data operation returned false, unable to delete Store");
            }
        }
        catch (NoSuchElementException e) {
            toReturn.getDataOperationMessages().add("No GeoServer Found under scope " + ScopeUtils.getCurrentScope());
        }
        catch (IllegalArgumentException e) {
            if (publisher == null) {
                toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
            } else {
                toReturn.getDataOperationMessages().add("Unable to publish data, cause :" + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            toReturn.getDataOperationMessages().add("Unable to instatiate GeoServerRESTPublisher, cause :" + e.getMessage());
        }
        catch (Exception e) {
            toReturn.getMetaOperationMessages().add("Unable to delete metadata, cause :" + e.getMessage());
        }
        return toReturn;
    }

    public void createWorkspace(String workspace) {
        log.info("Create workspace {} in geoservers", (Object)workspace);
        if (workspace == null || workspace.length() < 1) {
            throw new RuntimeException("Invalid workspace name : " + workspace);
        }
        for (AbstractGeoServerDescriptor gs : this.getCurrentCacheElements(false)) {
            try {
                GISInterface.createWorkspace(workspace, gs);
            }
            catch (MalformedURLException e) {
                log.warn("Wrong URL in descriptor {} ", (Object)gs.getUrl(), (Object)e);
            }
            catch (IllegalArgumentException e) {
                log.warn("Unable to operate service in {} ", (Object)gs.getUrl(), (Object)e);
            }
            catch (Exception e) {
                log.warn("Unable to check/create ws {} in {} ", new Object[]{workspace, gs.getUrl(), e});
            }
        }
    }

    public void createDataStore(String workspace, GSAbstractStoreEncoder datastore) {
        log.info("Create datastore {}, ws {} in geoservers", (Object)datastore, (Object)workspace);
        if (workspace == null || workspace.length() < 1) {
            throw new RuntimeException("Invalid workspace name : " + workspace);
        }
        if (datastore == null) {
            throw new RuntimeException("Invalid datastore " + datastore);
        }
        for (AbstractGeoServerDescriptor gs : this.getCurrentCacheElements(false)) {
            try {
                GISInterface.createDataStore(workspace, datastore, gs);
            }
            catch (MalformedURLException e) {
                log.warn("Wrong URL in descriptor {} ", (Object)gs.getUrl(), (Object)e);
            }
            catch (IllegalArgumentException e) {
                log.warn("Unable to operate service in {} ", (Object)gs.getUrl(), (Object)e);
            }
            catch (Exception e) {
                log.warn("Unable to check/create ws {} in {} ", new Object[]{workspace, gs.getUrl(), e});
            }
        }
    }

    private static void createWorkspace(String workspace, AbstractGeoServerDescriptor gs) throws MalformedURLException, IllegalArgumentException, Exception {
        if (gs == null) {
            throw new IllegalArgumentException("GeoServer Descriptor is " + gs);
        }
        log.info("Creating ws {} in {} ", (Object)workspace, (Object)gs.getUrl());
        if (workspace == null || workspace.length() < 1) {
            throw new RuntimeException("Invalid workspace name : " + workspace);
        }
        if (gs.getWorkspaces().contains(workspace)) {
            log.debug("Workspace {} already existing in {} ", (Object)workspace, (Object)gs.getUrl());
        } else {
            boolean result = gs.getPublisher().createWorkspace(workspace);
            gs.onChangedWorkspaces();
            if (!gs.getWorkspaces().contains(workspace)) {
                throw new Exception("Workspace is not created. Create operation returned " + result);
            }
        }
    }

    private static void createDataStore(String workspace, GSAbstractStoreEncoder datastore, AbstractGeoServerDescriptor gs) throws MalformedURLException, IllegalArgumentException, Exception {
        if (gs == null) {
            throw new IllegalArgumentException("GeoServer Descriptor is " + gs);
        }
        log.info("Create datastore {}, ws {} in {} ", new Object[]{datastore, workspace, gs.getUrl()});
        if (workspace == null || workspace.length() < 1) {
            throw new RuntimeException("Invalid workspace name : " + workspace);
        }
        GISInterface.createWorkspace(workspace, gs);
        if (gs.getDatastores(workspace).contains(datastore.getName())) {
            log.debug("Datastore {}:{} already existing in {}", new Object[]{workspace, datastore.getName(), gs.getUrl()});
        } else {
            boolean result = gs.getDataStoreManager().create(workspace, datastore);
            gs.onChangedDataStores();
            if (!gs.getDatastores(workspace).contains(datastore.getName())) {
                throw new Exception("Datastore not created. Create operation returned " + result);
            }
        }
    }

    private GeoServerCache getCache() {
        return this.theActualCache;
    }

    private synchronized GeoNetworkPublisher getGN() throws Exception {
        if (this.geoNetwork == null) {
            this.geoNetwork = GeoNetwork.get();
            if (this.toRegisterXMLAdapters != null) {
                for (XMLAdapter adapter : this.toRegisterXMLAdapters) {
                    this.geoNetwork.registerXMLAdapter(adapter);
                }
            }
        }
        return this.geoNetwork;
    }

    public AbstractGeoServerDescriptor getCurrentGeoServer() {
        return this.getCache().getDefaultDescriptor();
    }

    public SortedSet<AbstractGeoServerDescriptor> getCurrentCacheElements(Boolean forceUpdate) {
        return this.getCache().getDescriptorSet(forceUpdate);
    }

    @Deprecated
    public GeoServerRESTReader getGeoServerReader(ResearchMethod method, boolean forceRefresh) throws Exception {
        log.warn("*************** ACCESS TO DEPRECATED METHOD GeoServerRESTReader getGeoServerReader(ResearchMethod method,boolean forceRefresh). Please update your code.");
        return ((AbstractGeoServerDescriptor)this.getCache().getDescriptor(forceRefresh, method)).getReader();
    }

    @Deprecated
    public GeoServerRESTReader getGeoServerReader(GeoServerDescriptor desc) throws Exception {
        log.warn("*************** ACCESS TO DEPRECATED METHOD GeoServerRESTReader getGeoServerReader(GeoServerDescriptor desc). Please update your code.");
        return desc.getReader();
    }

    @Deprecated
    public GeoServerRESTReader getGeoServerReader(String url, String user, String password) throws IllegalArgumentException, MalformedURLException {
        log.warn("*************** ACCESS TO DEPRECATED METHOD GeoServerRESTReader getGeoServerReader(String url,String user,String password). Please update your code.");
        return new GeoServerDescriptor(url, user, password, 0L).getReader();
    }

    @Deprecated
    public GeoServerRESTReader getGeoServerReader(String url) throws MalformedURLException {
        log.warn("*************** ACCESS TO DEPRECATED METHOD GeoServerRESTReader getGeoServerReader(String url). Please update your code.");
        return new GeoServerRESTReader(url);
    }

    @Deprecated
    public GeoServerDescriptor getCurrentGeoServerDescriptor() {
        log.warn("*************** ACCESS TO DEPRECATED METHOD GeoServerDescriptor getCurrentGeoServerDescriptor(). Please update your code.");
        return this.translate((AbstractGeoServerDescriptor)this.getCache().getDefaultDescriptor());
    }

    @Deprecated
    public SortedSet<GeoServerDescriptor> getGeoServerDescriptorSet(boolean forceRefresh) {
        log.warn("*************** ACCESS TO DEPRECATED METHOD SortedSet<GeoServerDescriptor> getGeoServerDescriptorSet(boolean forceRefresh). Please update your code.");
        ConcurrentSkipListSet<GeoServerDescriptor> toReturn = new ConcurrentSkipListSet<GeoServerDescriptor>();
        for (Object desc : this.getCache().getDescriptorSet(forceRefresh)) {
            toReturn.add(this.translate((AbstractGeoServerDescriptor)desc));
        }
        return toReturn;
    }

    @Deprecated
    private GeoServerDescriptor translate(AbstractGeoServerDescriptor desc) {
        long count = 0L;
        try {
            count = desc.getHostedLayersCount();
        }
        catch (Exception e) {
            log.warn("Unable to get layer count from desc {} ", (Object)desc, (Object)e);
        }
        return new GeoServerDescriptor(desc.getUrl(), desc.getUser(), desc.getPassword(), count);
    }
}

