/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi;

import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LocalConfiguration.class);
    public static final String GEONETWORK_CACHE_TTL = "gn.cache.TTL";
    public static final String GEONETWORK_SE_CATEGORY = "gn.se.category";
    public static final String GEONETWORK_SE_PLATFORM = "gn.se.platform";
    public static final String GEONETWORK_SE_PRIORITY = "gn.se.priority";
    public static final String GEONETWORK_SE_ENDPOINT_NAME = "gn.se.endpointName";
    public static final String GEOSERVER_CACHE_TTL = "gs.cache.TTL";
    public static final String THREDDS_CACHE_TTL = "th.cache.TTL";
    public static final String THREDDS_SE_CATEGORY = "th.se.category";
    public static final String THREDDS_SE_PLATFORM = "th.se.platform";
    public static final String THREDDS_GE_SERVICE_CLASS = "th.ge.serviceClass";
    public static final String THREDDS_GE_SERVICE_NAME = "th.ge.serviceName";
    static LocalConfiguration instance = null;
    private Properties props = new Properties();

    public static synchronized LocalConfiguration get() {
        return instance;
    }

    public static void init(URL propertiesURL) {
        instance = new LocalConfiguration(propertiesURL);
    }

    private LocalConfiguration(URL propertiesURL) {
        try {
            log.debug("Loading {} ", (Object)propertiesURL);
            this.props.load(propertiesURL.openStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getProperty(String property) {
        return this.props.getProperty(property);
    }

    public String getProperty(String property, String defaultValue) {
        return this.props.getProperty(property, defaultValue);
    }
}

