/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.AbstractGeoServerDescriptor;
import org.gcube.spatial.data.sdi.engine.impl.cache.ObjectRetriever;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoServerClusterConfiguration;
import org.gcube.spatial.data.sdi.model.service.GeoServerConfiguration;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoServerClusterRetriever
implements ObjectRetriever<GeoServerClusterConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(GeoServerClusterRetriever.class);

    public GeoServerClusterConfiguration getObject() throws ConfigurationNotFoundException {
        log.info("Retrieving GeoServer cluster configuration under scope {}", (Object)ScopeUtils.getCurrentScope());
        try {
            GISInterface gis = GISInterface.get((AbstractGeoServerDescriptor[])new AbstractGeoServerDescriptor[0]);
            ArrayList<GeoServerConfiguration> availableInstances = new ArrayList<GeoServerConfiguration>();
            for (AbstractGeoServerDescriptor desc : gis.getCurrentCacheElements(Boolean.valueOf(true))) {
                try {
                    availableInstances.add(GeoServerClusterRetriever.translate((AbstractGeoServerDescriptor)desc));
                }
                catch (Throwable t) {
                    log.warn("Unable to translate descriptor for endpoint" + desc.getUrl(), t);
                }
            }
            return new GeoServerClusterConfiguration(availableInstances);
        }
        catch (Exception e) {
            log.warn("Unable to gather geoserver cluster configuration on scope " + ScopeUtils.getCurrentScope(), (Throwable)e);
            throw new ConfigurationNotFoundException("Unable to gather geoserver cluster configuration. Please ontact administrator.", (Throwable)e);
        }
    }

    private static final GeoServerConfiguration translate(AbstractGeoServerDescriptor desc) {
        Version version = new Version(Integer.valueOf(2), Integer.valueOf(1), Integer.valueOf(2));
        String baseEndpoint = desc.getUrl();
        List<Credentials> accessibleCredentials = Collections.singletonList(new Credentials(desc.getUser(), desc.getPassword(), AccessType.ADMIN));
        String confidentialWorkspace = null;
        String contextVisibilityWorkspace = null;
        String sharedWorkspace = null;
        String publicWorkspace = null;
        return new GeoServerConfiguration(version, baseEndpoint, accessibleCredentials, confidentialWorkspace, contextVisibilityWorkspace, sharedWorkspace, publicWorkspace);
    }
}

