/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.faults.DataTransferException;
import org.gcube.data.transfer.model.PluginDescription;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.NetUtils;
import org.gcube.spatial.data.sdi.engine.impl.cache.AbstractISModule;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceDefinitionException;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.health.Level;
import org.gcube.spatial.data.sdi.model.health.Status;
import org.gcube.spatial.data.sdi.model.service.ThreddsConfiguration;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.ThreddsDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ThreddsRetriever
extends AbstractISModule<ThreddsConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ThreddsRetriever.class);

    public ThreddsConfiguration getObject() throws ConfigurationNotFoundException {
        log.info("Loading Thredds information from IS. Current Scope is {} ", (Object)ScopeUtils.getCurrentScope());
        List threddsSE = this.getServiceEndpoints();
        if (threddsSE != null && !threddsSE.isEmpty()) {
            log.debug("Found {} Service Endpoints ", (Object)threddsSE.size());
            int i = 0;
            while (i < threddsSE.size()) {
                ServiceEndpoint endpoint = (ServiceEndpoint)threddsSE.get(i);
                try {
                    log.debug("Checking element {}, ID {} ", (Object)i, (Object)endpoint.id());
                    ThreddsConfiguration toReturn = ThreddsRetriever.translate((ServiceEndpoint)endpoint);
                    if (toReturn == null) {
                        throw new Exception("Translated configuration was null");
                    }
                    return toReturn;
                }
                catch (Throwable t) {
                    log.warn("Unable to read retrieved service endpoint ID " + endpoint.id(), t);
                    ++i;
                }
            }
        }
        throw new ConfigurationNotFoundException("Thredds has not been found in current scope " + ScopeUtils.getCurrentScope());
    }

    protected String getGCoreEndpointServiceClass() {
        return LocalConfiguration.get().getProperty("th.ge.serviceClass");
    }

    protected String getGCoreEndpointServiceName() {
        return LocalConfiguration.get().getProperty("th.ge.serviceName");
    }

    protected String getManagedServiceType() {
        return "THREDDS";
    }

    protected String getServiceEndpointCategory() {
        return LocalConfiguration.get().getProperty("th.se.category");
    }

    protected String getServiceEndpointPlatformName() {
        return LocalConfiguration.get().getProperty("th.se.platform");
    }

    protected String getServiceEndpointAccessPointName() {
        return LocalConfiguration.get().getProperty("th.se.endpointName");
    }

    protected List<Status> performInstanceCheck(ServiceEndpoint se) {
        ArrayList<Status> toReturn = new ArrayList<Status>();
        String hostname = se.profile().runtime().hostedOn();
        try {
            log.trace("Checking thredds hosted on {} ", (Object)hostname);
            String publicCatalogUrl = "www." + hostname + "/thredds/catalog/public/netcdf/catalog.html";
            if (!NetUtils.isUp((String)publicCatalogUrl)) {
                toReturn.add(new Status("Unreachable default THREDDS catalog at " + publicCatalogUrl, Level.ERROR));
            } else {
                DataTransferClient client = DataTransferClient.getInstanceByEndpoint((String)hostname);
                boolean found = false;
                for (PluginDescription desc : client.getDestinationCapabilities().getAvailablePlugins()) {
                    if (!desc.getId().equals("SIS/GEOTK")) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    toReturn.add(new Status("SIS/GEOTK plugin for DataTransfer service not found on " + hostname, Level.ERROR));
                }
            }
        }
        catch (IOException e) {
            String msg = "Unable to check thredds instance hosted on " + hostname;
            log.warn(msg);
            log.debug("Exception was ", (Throwable)e);
            toReturn.add(new Status(msg, Level.WARNING));
        }
        catch (DataTransferException e) {
            String msg = "DataTransfer not found in host " + hostname;
            log.warn(msg);
            log.debug("Exception was ", (Throwable)e);
            toReturn.add(new Status(msg, Level.ERROR));
        }
        return toReturn;
    }

    private static final ThreddsConfiguration translate(ServiceEndpoint toTranslate) {
        Platform platform = toTranslate.profile().platform();
        Version version = new Version(Short.valueOf(platform.version()), platform.minorVersion(), platform.revisionVersion());
        ServiceEndpoint.AccessPoint access = (ServiceEndpoint.AccessPoint)toTranslate.profile().accessPoints().iterator().next();
        Credentials credentials = new Credentials(access.username(), access.password(), AccessType.ADMIN);
        return new ThreddsConfiguration(version, access.address(), Collections.singletonList(credentials));
    }

    protected void checkDefinitionForServiceType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
    }

    protected void checkDefinitionType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
        if (!definition.getType().equals((Object)ServiceDefinition.Type.THREDDS) || !(definition instanceof ThreddsDefinition)) {
            throw new InvalidServiceDefinitionException("Invalid service type [expected " + ServiceDefinition.Type.THREDDS + "]. Definition was " + definition);
        }
    }
}

