package org.gcube.spatial.data.sdi.engine.impl;

import java.util.Collections;
import java.util.List;

import javax.inject.Singleton;

import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.GeoNetworkManager;
import org.gcube.spatial.data.sdi.engine.impl.cluster.AbstractCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoNetworkCluster;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoNetworkController;
import org.gcube.spatial.data.sdi.engine.impl.faults.ConfigurationNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.is.GeoNetworkRetriever;
import org.gcube.spatial.data.sdi.engine.impl.is.ISModule;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.gcube.spatial.data.sdi.model.services.GeoNetworkServiceDefinition;

@Singleton
public class GeoNetworkManagerImpl extends AbstractManager<GeoNetworkDescriptor, GeoNetworkServiceDefinition, GeoNetworkController> implements GeoNetworkManager {


	private GeoNetworkRetriever retriever=null;
	private GeoNetworkCluster cluster=null;

	public GeoNetworkManagerImpl() {
		retriever=new GeoNetworkRetriever();
		cluster=new GeoNetworkCluster(LocalConfiguration.getTTL(LocalConfiguration.GEONETWORK_CACHE_TTL), retriever, "GeoNEtwork - cache");
	}


	@Override
	protected AbstractCluster<GeoNetworkDescriptor, GeoNetworkController> getCluster() {
		return cluster;
	}	

	@Override
	protected ISModule getRetriever() {
		return retriever;
	}
	
	@Override
	public List<GeoNetworkDescriptor> getSuggestedInstances() throws ConfigurationNotFoundException {
		return Collections.singletonList(getCluster().getDefaultController().getDescriptor());
	}
	
}
