/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cluster;

import java.util.Map;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.OutdatedServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceInteractionException;
import org.gcube.spatial.data.sdi.engine.impl.is.CachedObject;
import org.gcube.spatial.data.sdi.engine.impl.is.ISUtils;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoServiceDescriptor;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeoServiceController<T extends GeoServiceDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(GeoServiceController.class);
    protected ServiceEndpoint serviceEndpoint;
    protected ServiceEndpoint.AccessPoint accessPoint;
    protected Map<String, ServiceEndpoint.Property> propertyMap;
    protected String baseURL;
    protected Credentials adminAccount;
    protected Version version;
    protected CachedObject<T> cachedDescriptor = null;

    public synchronized T getDescriptor() {
        if (this.cachedDescriptor == null || this.cachedDescriptor.isValid(500L)) {
            this.cachedDescriptor = new CachedObject((Object)this.getLiveDescriptor());
        }
        return (T)((GeoServiceDescriptor)this.cachedDescriptor.getTheObject());
    }

    protected abstract T getLiveDescriptor();

    protected abstract ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint var1);

    public GeoServiceController(ServiceEndpoint serviceEndpoint) throws InvalidServiceEndpointException {
        this.setServiceEndpoint(serviceEndpoint);
    }

    public void onUpdateServiceEndpoint() {
        this.setServiceEndpoint(ISUtils.updateAndWait((ServiceEndpoint)this.serviceEndpoint));
        this.cachedDescriptor.invalidate();
    }

    protected void setServiceEndpoint(ServiceEndpoint toSet) {
        this.serviceEndpoint = toSet;
        ServiceEndpoint.Profile profile = this.serviceEndpoint.profile();
        ServiceEndpoint.AccessPoint point = this.getTheRightAccessPoint(this.serviceEndpoint);
        this.propertyMap = this.accessPoint.propertyMap();
        this.baseURL = point.address();
        this.adminAccount = new Credentials(point.username(), point.password(), AccessType.ADMIN);
        Platform platform = profile.platform();
        this.version = new Version(Short.valueOf(platform.version()), platform.minorVersion(), platform.revisionVersion());
    }

    protected abstract void initServiceEndpoint() throws OutdatedServiceEndpointException, ServiceInteractionException;

    public void configure() throws ServiceInteractionException {
        try {
            this.initServiceEndpoint();
        }
        catch (OutdatedServiceEndpointException e) {
            this.onUpdateServiceEndpoint();
        }
    }

    protected String getSEProperty(String property, boolean mandatory) throws InvalidServiceEndpointException {
        if (!this.propertyMap.containsKey(property)) {
            if (mandatory) {
                throw new InvalidServiceEndpointException("Expected property " + property + " was not found.");
            }
            return null;
        }
        ServiceEndpoint.Property prop = (ServiceEndpoint.Property)this.propertyMap.get(property);
        if (prop.isEncrypted()) {
            return ISUtils.decryptString((String)prop.value());
        }
        return prop.value();
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.serviceEndpoint;
    }
}

