/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cluster;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.client.AuthorizationFilter;
import org.gcube.data.transfer.library.faults.DestinationNotSetException;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidDestinationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsInfo;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.NetUtils;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoServiceController;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.OutdatedServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ThreddsOperationFault;
import org.gcube.spatial.data.sdi.engine.impl.is.ISUtils;
import org.gcube.spatial.data.sdi.model.service.ThreddsDescriptor;
import org.glassfish.jersey.client.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreddsController
extends GeoServiceController<ThreddsDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(ThreddsController.class);

    protected ThreddsDescriptor getLiveDescriptor() {
        return new ThreddsDescriptor(this.version, this.baseURL, Collections.EMPTY_LIST);
    }

    protected ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint endpoint) {
        for (ServiceEndpoint.AccessPoint declaredPoint : endpoint.profile().accessPoints().asCollection()) {
            if (!declaredPoint.name().equals(LocalConfiguration.getProperty((String)"th.se.remoteManagement.access"))) continue;
            return declaredPoint;
        }
        return null;
    }

    public ThreddsController(ServiceEndpoint serviceEndpoint) throws InvalidServiceEndpointException {
        super(serviceEndpoint);
    }

    protected void initServiceEndpoint() throws OutdatedServiceEndpointException {
    }

    public ThreddsInfo getThreddsInfo() {
        String infoPath = this.getThreddsInfoPath();
        log.info("Loading thredds info from {} ", (Object)infoPath);
        WebTarget target = this.getWebClient().target(infoPath);
        return (ThreddsInfo)target.request(new String[]{"application/json"}).get(ThreddsInfo.class);
    }

    private void reloadCatalog() throws IOException {
        ServiceEndpoint.AccessPoint ap = this.getTheRightAccessPoint(this.serviceEndpoint);
        NetUtils.makeAuthorizedCall((String)ap.address(), (String)ap.username(), (String)ISUtils.decryptString((String)ap.password()));
    }

    private String getHostName() {
        return this.getServiceEndpoint().profile().runtime().hostedOn();
    }

    private String getThreddsInfoPath() {
        return "https://" + this.getHostName() + "/data-transfer-service/gcube/service/Capabilities/pluginInfo/REGISTER_CATALOG";
    }

    private Client getWebClient() {
        return ClientBuilder.newClient((Configuration)new ClientConfig().register(AuthorizationFilter.class));
    }

    public ThreddsCatalog publishCatalog(File catalogFile, String reference) throws ThreddsOperationFault {
        log.trace("Registering Thredds catalog with reference {} ", (Object)reference);
        try {
            ServiceEndpoint.AccessPoint ap = this.getTheRightAccessPoint(this.getServiceEndpoint());
            log.debug("AP address is {} ", (Object)ap.address());
            DataTransferClient client = DataTransferClient.getInstanceByEndpoint((String)ap.address());
            Destination dest = new Destination();
            dest.setPersistenceId("thredds");
            dest.setDestinationFileName(reference.replace(" ", "_") + ".xml");
            dest.setOnExistingFileName(DestinationClashPolicy.REWRITE);
            PluginInvocation invocation = new PluginInvocation("REGISTER_CATALOG");
            invocation.setParameters(Collections.singletonMap("CATALOG_REFERENCE", reference));
            log.debug("Sending catalog file to Thredds for registration");
            client.localFile(catalogFile, dest, invocation);
            log.debug("Catalog registered, calling reload.. ");
            this.reloadCatalog();
            ThreddsInfo info = this.getThreddsInfo();
            log.debug("returned ThreddsInfo is {} ", (Object)info);
            return info.getById(reference);
        }
        catch (DestinationNotSetException | FailedTransferException | InitializationException | InvalidDestinationException | InvalidSourceException | SourceNotSetException e) {
            throw new ThreddsOperationFault("Unable to register catalog " + reference, e);
        }
        catch (Exception e) {
            throw new ThreddsOperationFault("Unable to reload catalog " + reference, (Throwable)e);
        }
    }
}

