/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.TemporaryPersistence;
import org.gcube.spatial.data.sdi.engine.impl.TemporaryPersistenceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class TemporaryPersistenceImpl
implements TemporaryPersistence {
    private static final Logger log = LoggerFactory.getLogger(TemporaryPersistenceImpl.class);
    private static final String UPLOADING_FILE_SUFFIX = ".part";
    private static final FileFilter TO_CHECK_FILES_FILTER = new /* Unavailable Anonymous Inner Class!! */;
    private File persistenceLocation = null;
    private ScheduledExecutorService service = null;

    @PostConstruct
    public void init() {
        try {
            this.persistenceLocation = Files.createTempDirectory("SDI", new FileAttribute[0]).toFile();
            System.out.println("************************************** TEMPORARY PERSISTENCE INIT **************************");
            System.out.println("SDI-Service - Temporary persistence location is " + this.persistenceLocation.getAbsolutePath());
            System.out.println("**************************************");
            log.trace("Temporary persistence is " + this.persistenceLocation.getAbsolutePath());
            this.service = new ScheduledThreadPoolExecutor(1);
            long TTL = Long.parseLong(LocalConfiguration.getProperty((String)"temp.ttl", (String)"120000"));
            log.debug("Temp TTL is {} ", (Object)TTL);
            long delay = TTL / 4L;
            this.service.scheduleWithFixedDelay((Runnable)new CleanUpThread(Long.valueOf(TTL), this.persistenceLocation, TO_CHECK_FILES_FILTER), delay, delay, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to init persistence ", t);
        }
    }

    public File getById(String id) throws FileNotFoundException {
        File toReturn = new File(this.persistenceLocation, id);
        if (!toReturn.exists()) {
            throw new FileNotFoundException();
        }
        return toReturn;
    }

    public String store(InputStream is) throws FileNotFoundException, IOException {
        String partUUID = TemporaryPersistenceImpl.getUUID() + ".part";
        log.debug("Storing file " + partUUID);
        File created = TemporaryPersistenceImpl.transferStream((InputStream)is, (File)new File(this.persistenceLocation, partUUID));
        String toReturn = created.getName().substring(0, created.getName().lastIndexOf(".") - 1);
        created.renameTo(new File(this.persistenceLocation, toReturn));
        log.debug("Completed. Part renamed to " + toReturn);
        return toReturn;
    }

    @PreDestroy
    public void clean(String id) {
        try {
            System.out.println("*************************************** TEMPORARY PERSISTENCE PRE DESTROY ******************************");
            Files.delete(Paths.get(this.persistenceLocation.getAbsolutePath(), id));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to clean up temporary persistence. ", t);
        }
    }

    public void shutdown() {
        log.debug("Shutting down persistence..");
        this.service.shutdownNow();
        log.debug("Clearing persistence folder..");
        for (File f : this.persistenceLocation.listFiles()) {
            try {
                if (f.delete()) continue;
                f.deleteOnExit();
            }
            catch (Throwable t) {
                log.warn("Exception while clearing persistence.. ", t);
            }
        }
    }

    public void update(String id, InputStream is) throws FileNotFoundException, IOException {
        File toUpdate = this.getById(id);
        TemporaryPersistenceImpl.transferStream((InputStream)is, (File)toUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File transferStream(InputStream in, File destination) throws FileNotFoundException, IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(destination, false);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = in.read(bytes)) != -1) {
                out.write(bytes, 0, read);
            }
            out.flush();
            File file = destination;
            return file;
        }
        finally {
            if (out != null) {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
    }

    private static String getUUID() {
        return UUID.randomUUID().toString().replace(" ", "_");
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

