package org.gcube.usecases.ws.thredds.engine.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map.Entry;

import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

import org.gcube.common.calls.Call;
import org.gcube.common.calls.Interceptors;
import org.gcube.common.calls.Request;
import org.gcube.data.transfer.library.utils.ScopeUtils;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class CustomAuthorizationFilter  implements ClientRequestFilter {

	
	@Override
	public void filter(final ClientRequestContext rc) throws IOException {
		if (ScopeUtils.getCurrentScope()!=null){
			Request requestContext = Interceptors.executeRequestChain(new Call());

			for (Entry<String, String> entry: requestContext.getHeaders()){
				log.debug("Copying HTTP request header {} : {}",entry.getKey(),entry.getValue());
				rc.getHeaders().put(entry.getKey(), Collections.singletonList((Object)entry.getValue()));	
			}
		}
	}
}
