/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gcube.usecases.ws.thredds.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LocalConfiguration.class);
    private static final Object $LOCK = new Object[0];
    private static LocalConfiguration instance = null;
    Properties props = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final LocalConfiguration get() {
        Object object = $LOCK;
        synchronized (object) {
            if (instance == null) {
                instance = new LocalConfiguration();
            }
            return instance;
        }
    }

    public static String getProperty(String property) {
        try {
            return (String)LocalConfiguration.get().props.getOrDefault((Object)property, Constants.defaultConfigurationMap.get(property));
        }
        catch (Throwable t) {
            log.warn("Unable to get configuration property " + property, t);
            return Constants.defaultConfigurationMap.get(property) + "";
        }
    }

    public Map<String, String> asMap() {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (Object key : this.props.keySet()) {
            toReturn.put(key + "", (String)this.props.getOrDefault(key, Constants.defaultConfigurationMap.get(key)));
        }
        return toReturn;
    }

    private LocalConfiguration() {
        try {
            this.props.load(this.getClass().getResourceAsStream("configuration.properties"));
        }
        catch (Exception e) {
            log.warn("********************** UNABLE TO LOAD PROPERTIES **********************", (Throwable)e);
            log.debug("Reverting to defaults : " + Constants.defaultConfigurationMap);
        }
    }
}

