/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.util.concurrent.atomic.AtomicLong;

public class ProcessStatus
implements Cloneable {
    private AtomicLong queuedTransfers = new AtomicLong(0L);
    private AtomicLong servedTransfers = new AtomicLong(0L);
    private AtomicLong errorCount = new AtomicLong(0L);
    private Status status = Status.INITIALIZING;
    private StringBuilder logBuilder = new StringBuilder();
    private String currentMessage = "Waiting to start..";

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return "ProcessStatus [queuedTransfers=" + this.queuedTransfers + ", servedTransfers=" + this.servedTransfers + ", errorCount=" + this.errorCount + ", status=" + (Object)((Object)this.status) + ", currentMessage=" + this.currentMessage + "]";
    }

    public float getPercent() {
        switch (this.status) {
            case INITIALIZING: {
                return 0.0f;
            }
            case COMPLETED: {
                return 1.0f;
            }
        }
        return this.queuedTransfers.get() == 0L ? 0.0f : (float)(this.servedTransfers.get() + this.errorCount.get()) / (float)this.queuedTransfers.get();
    }

    public AtomicLong getQueuedTransfers() {
        return this.queuedTransfers;
    }

    public AtomicLong getServedTransfers() {
        return this.servedTransfers;
    }

    public AtomicLong getErrorCount() {
        return this.errorCount;
    }

    public Status getStatus() {
        return this.status;
    }

    public StringBuilder getLogBuilder() {
        return this.logBuilder;
    }

    public String getCurrentMessage() {
        return this.currentMessage;
    }

    public void setQueuedTransfers(AtomicLong queuedTransfers) {
        this.queuedTransfers = queuedTransfers;
    }

    public void setServedTransfers(AtomicLong servedTransfers) {
        this.servedTransfers = servedTransfers;
    }

    public void setErrorCount(AtomicLong errorCount) {
        this.errorCount = errorCount;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setLogBuilder(StringBuilder logBuilder) {
        this.logBuilder = logBuilder;
    }

    public void setCurrentMessage(String currentMessage) {
        this.currentMessage = currentMessage;
    }

    public static enum Status {
        INITIALIZING,
        ONGOING,
        WARNINGS,
        STOPPED,
        COMPLETED;

    }
}

