/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl.security;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AccessTokenProvider;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.usecases.ws.thredds.engine.impl.security.SecurityException;
import org.gcube.usecases.ws.thredds.engine.impl.security.User;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Security {
    private static final Logger log = LoggerFactory.getLogger(Security.class);

    public static User getCurrent() throws SecurityException {
        String context = ScopeProvider.instance.get();
        if (context == null) {
            throw new SecurityException("Cannot determine context");
        }
        log.debug("Context is {}, checking tokens..", (Object)context);
        ClientInfo client = null;
        try {
            AuthorizationProvider.instance.get().getClient();
        }
        catch (Throwable e) {
            log.warn("Unable to get client info ", e);
        }
        User toReturn = new User(client, AccessTokenProvider.instance.get(), SecurityTokenProvider.instance.get(), context);
        log.info("Current User is {} ", (Object)toReturn);
        return toReturn;
    }

    public static void set(User toSet) {
        Security.resetUser();
        log.debug("Setting User {} ", (Object)toSet);
        if (toSet.getUma_token() != null) {
            AccessTokenProvider.instance.set(toSet.getUma_token());
        }
        if (toSet.getGcube_token() != null) {
            SecurityTokenProvider.instance.set(toSet.getGcube_token());
        }
        if (toSet.getContext() != null) {
            ScopeProvider.instance.set(toSet.getContext());
        }
    }

    public static void resetUser() {
        log.debug("Resetting user");
        SecurityTokenProvider.instance.reset();
        AccessTokenProvider.instance.reset();
        ScopeProvider.instance.reset();
    }

    public static void checkOperator(SynchFolderConfiguration config) throws SecurityException {
        User current = Security.getCurrent();
        log.debug("Checking if current user {} can synch {} ", (Object)Security.getCurrent(), (Object)config);
        String expectedContext = config.getTargetContext();
        String currentContext = current.getContext();
        if (!expectedContext.equals(currentContext)) {
            throw new SecurityException("Illegal access to folder [root : " + config.getRootFolderId() + ", expected context : " + expectedContext + "] from context " + currentContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContextFromgcubeToken(String token) throws ObjectNotFound, Exception {
        log.debug("Checking context of gcube-token {}...", (Object)token.substring(0, 6));
        User caller = Security.getCurrent();
        try {
            Security.resetUser();
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            String string = entry.getContext();
            return string;
        }
        finally {
            log.debug("Resetting user " + caller);
            Security.set(caller);
        }
    }
}

