package org.gcube.data.analysis.tabulardata.service.operation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

import com.google.common.collect.ImmutableList;

public class ImmutableTask implements Task {
	
	private TaskId id;
	
	private OperationInvocation sourceOperationInvocation;
	
	private List<TaskJob> operationInstanceSteps;

	private JobResult operationResult; 

	private float progress;
	
	private ActivityStatus status;
	
	private Date startTime;
	
	private Date endTime;
	
	private String invokerUsername;
	
	private List<TabularResourceId> collateralTabularResourceIds = new ArrayList<TabularResourceId>();
	
	public ImmutableTask(TaskId id, OperationInvocation sourceOperationInvocation,
			List<TaskJob> jobs, JobResult operationResult, float progress,
			ActivityStatus status, Date startTime, Date endTime, String invokerUsername) {
		this.id = id;
		this.sourceOperationInvocation = sourceOperationInvocation;
		this.operationInstanceSteps = jobs;
		this.operationResult = operationResult;
		this.progress = progress;
		this.status = status;
		this.startTime = startTime;
		this.endTime = endTime;
		this.invokerUsername = invokerUsername;
	}
	
	public ImmutableTask(TaskId id, OperationInvocation sourceOperationInvocation,
			List<TaskJob> operationInstanceSteps, JobResult operationResult, float progress, ActivityStatus status,
			Date startTime, Date endTime, String invokerUsername, List<TabularResourceId> collateralTabularResourceIds) {
		this.id = id;
		this.sourceOperationInvocation = sourceOperationInvocation;
		this.operationInstanceSteps = operationInstanceSteps;
		this.operationResult = operationResult;
		this.progress = progress;
		this.status = status;
		this.startTime = startTime;
		this.endTime = endTime;
		this.invokerUsername = invokerUsername;
		this.collateralTabularResourceIds = collateralTabularResourceIds;
	}

	@Override
	public TaskId getId() {
		return id;
	}

	@Override
	public OperationInvocation getSourceInvocation() {
		return sourceOperationInvocation;
	}

	@Override
	public JobResult getResult() {
		return operationResult;
	}

	@Override
	public float getProgress() {
		return progress;
	}

	@Override
	public ActivityStatus getStatus() {
		return status;
	}

	@Override
	public Date getStartTime() {
		return startTime;
	}

	@Override
	public Date getEndTime() {
		return endTime;
	}

	@Override
	public String getInvokerUsername() {
		return invokerUsername;
	}

	@Override
	public List<TaskJob> getTaskJobs() {
		return operationInstanceSteps;
	}

	@Override
	public List<TabularResourceId> getCollateralTabularResourceIds() {
		return ImmutableList.copyOf(collateralTabularResourceIds);
	}

	@Override
	public void abort() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ImmutableTask [id=");
		builder.append(id);
		builder.append(", sourceOperationInvocation=");
		builder.append(sourceOperationInvocation);
		builder.append(", operationInstanceSteps=");
		builder.append(operationInstanceSteps);
		builder.append(", operationResult=");
		builder.append(operationResult);
		builder.append(", progress=");
		builder.append(progress);
		builder.append(", status=");
		builder.append(status);
		builder.append(", startTime=");
		builder.append(startTime);
		builder.append(", endTime=");
		builder.append(endTime);
		builder.append(", invokerUsername=");
		builder.append(invokerUsername);
		builder.append("]");
		return builder.toString();
	}

}
