package org.gcube.data.analysis.tabulardata.service.operation;

import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.Job;

public class ImmutableTaskJob implements TaskJob {

	private Job delegateJob;

	private TaskJobClassifier classifier;

	public ImmutableTaskJob(Job delegateJob, TaskJobClassifier classifier) {
		this.delegateJob = delegateJob;
		this.classifier = classifier;
	}

	public float getProgress() {
		return delegateJob.getProgress();
	}

	public ActivityStatus getStatus() {
		return delegateJob.getStatus();
	}

	public OperationInvocation getSourceInvocation() {
		return delegateJob.getSourceInvocation();
	}

	public JobResult getResult() {
		return delegateJob.getResult();
	}

	@Override
	public TaskJobClassifier getClassifier() {
		return classifier;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ImmutableTaskJob [delegateJob=");
		builder.append(delegateJob);
		builder.append(", classifier=");
		builder.append(classifier);
		builder.append("]");
		return builder.toString();
	}

}
