/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.testsuite;

import java.io.IOException;
import java.rmi.Remote;
import java.util.Properties;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.AddResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.CreateScopeParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.OptionsParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceItem;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceList;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceManagerPortType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ScopeOption;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceItem;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceList;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.service.ResourceManagerServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.testsuite.security.Utils;

public class CreateScopeTest {
    protected static Properties resources = new Properties();
    protected static String[] optionNames = new String[]{"creator", "designer", "endTime", "startTime", "description", "displayName", "securityenabled"};
    protected static GCUBEClientLog logger = new GCUBEClientLog(CreateScopeTest.class, new Properties[0]);

    public static void main(String[] args) {
        if (args.length < 2) {
            CreateScopeTest.printUsage();
        }
        try {
            resources.load(CreateScopeTest.class.getResourceAsStream("/" + args[1]));
        }
        catch (IOException e1) {
            logger.error((Object)"Unable to load the properties file", (Throwable)e1);
            Runtime.getRuntime().exit(1);
        }
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress((AttributedURI)new Address(args[0]));
            ResourceManagerPortType pt = new ResourceManagerServiceAddressingLocator().getResourceManagerPortTypePort(endpoint);
            if (args.length == 3) {
                GCUBESecurityManager securityManager = Utils.generateAndConfigureDefaultSecurityManager(args[2], true);
                securityManager.setSecurity((Remote)pt, GCUBESecurityManager.AuthMode.PRIVACY, GCUBESecurityManager.DelegationMode.FULL);
                pt = (ResourceManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)resources.getProperty("callerScope").trim()), (GCUBESecurityManager[])new GCUBESecurityManager[]{securityManager});
            } else {
                pt = (ResourceManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)resources.getProperty("callerScope").trim()), (int)90000, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            }
            logger.info((Object)"Setting the Scope parameters...");
            OptionsParameters options = new OptionsParameters();
            ScopeOption[] scopeOptionList = new ScopeOption[optionNames.length];
            for (int i = 0; i < optionNames.length; ++i) {
                if (resources.getProperty(optionNames[i]) == null) continue;
                logger.info((Object)("Setting prop " + optionNames[i]));
                scopeOptionList[i] = new ScopeOption(optionNames[i], resources.getProperty(optionNames[i]));
            }
            options.setScopeOptionList(scopeOptionList);
            AddResourcesParameters add = new AddResourcesParameters();
            if (new Integer(resources.getProperty("numOfServicesToAdd")) > 0) {
                ServiceItem[] servicelist = new ServiceItem[new Integer(resources.getProperty("numOfServicesToAdd")).intValue()];
                for (int i = 1; i < servicelist.length + 1; ++i) {
                    servicelist[i - 1] = new ServiceItem();
                    servicelist[i - 1].setServiceClass(resources.getProperty("service." + i + ".class"));
                    servicelist[i - 1].setServiceName(resources.getProperty("service." + i + ".name"));
                    servicelist[i - 1].setServiceVersion(resources.getProperty("service." + i + ".version"));
                    if (resources.getProperty("service." + i + ".GHN") == null) continue;
                    servicelist[i - 1].setGHN(resources.getProperty("service." + i + ".GHN"));
                }
                ServiceList l = new ServiceList();
                l.setService(servicelist);
                if (resources.getProperty("GHNSet") != null) {
                    String[] ghns = resources.getProperty("GHNSet").split(",");
                    l.setGHN(ghns);
                }
                add.setServices(l);
            }
            if (new Integer(resources.getProperty("numOfResourcesToAdd")) > 0) {
                ResourceItem[] resourcelist = new ResourceItem[new Integer(resources.getProperty("numOfResourcesToAdd")).intValue()];
                for (int i = 1; i < resourcelist.length + 1; ++i) {
                    resourcelist[i - 1] = new ResourceItem();
                    resourcelist[i - 1].setID(resources.getProperty("resource." + i + ".id"));
                    resourcelist[i - 1].setType(resources.getProperty("resource." + i + ".type"));
                }
                ResourceList r = new ResourceList();
                r.setResource(resourcelist);
                add.setResources(r);
            }
            add.setTargetScope(resources.getProperty("targetScope"));
            logger.info((Object)"Sending the creation request....");
            CreateScopeParameters params = new CreateScopeParameters();
            params.setName(resources.getProperty("targetScope"));
            params.setOptionsParameters(options);
            params.setAddResourcesParameters(add);
            String reportID = pt.createScope(params);
            logger.info((Object)("Returned report ID: " + reportID));
        }
        catch (Exception e) {
            logger.fatal((Object)"Failed to create VRE", (Throwable)e);
        }
    }

    static void printUsage() {
        System.out.println("CreateScopeTest http://host:port/wsrf/services/gcube/vremanagement/ResourceManager <properties file>");
        System.out.println("or");
        System.out.println("CreateScopeTest https://host:port/wsrf/services/gcube/vremanagement/ResourceManager <properties file> <identity>");
        System.exit(1);
    }
}

