/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.deploytest.client;

import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.types.VOID;
import org.gcube.deploytest.client.Deploy;
import org.gcube.deploytest.client.QueryDeploymentInformation;
import org.gcube.deploytest.client.QueryInformationSystem;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.ReportingPortType;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.service.ReportingServiceAddressingLocator;
import org.gcube.vremanagement.vremodeler.stubs.CollectionArray;
import org.gcube.vremanagement.vremodeler.stubs.CollectionList;
import org.gcube.vremanagement.vremodeler.stubs.CollectionType;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityIDArray;
import org.gcube.vremanagement.vremodeler.stubs.GHNArray;
import org.gcube.vremanagement.vremodeler.stubs.ModelerFactoryPortType;
import org.gcube.vremanagement.vremodeler.stubs.ModelerServicePortType;
import org.gcube.vremanagement.vremodeler.stubs.VREDescription;
import org.gcube.vremanagement.vremodeler.stubs.service.ModelerFactoryServiceAddressingLocator;
import org.gcube.vremanagement.vremodeler.stubs.service.ModelerServiceAddressingLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CreateVRE {
    public String ghn1 = null;
    public String ghn2 = null;
    protected String vreName;
    private QueryInformationSystem query = null;
    private ArrayList<String> resourceIds = new ArrayList();
    ModelerFactoryPortType mfptp = null;
    EndpointReferenceType eprModelerRes = null;

    public CreateVRE(String vreName, String ghn1, String ghn2, String scope) {
        this.ghn1 = ghn1;
        this.ghn2 = ghn2;
        this.vreName = vreName;
        new Deploy(scope);
        try {
            this.query = new QueryInformationSystem();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private ModelerServicePortType createVRE() throws RemoteException {
        ModelerFactoryServiceAddressingLocator mfal = new ModelerFactoryServiceAddressingLocator();
        Deploy.logInfo("Querying IS");
        try {
            this.mfptp = mfal.getModelerFactoryPortTypePort(this.query.getVREModelerEndpoint());
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        try {
            this.mfptp = (ModelerFactoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)this.mfptp, (GCUBEScope)GCUBEScope.getScope((String)Deploy.SCOPE), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.mfptp.initDB(new VOID());
            Thread.sleep(100000L);
        }
        catch (RemoteException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            this.eprModelerRes = this.mfptp.createResource(new VOID());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        Deploy.logInfo("VREModeler Resource created\n");
        ModelerServiceAddressingLocator msal = new ModelerServiceAddressingLocator();
        ModelerServicePortType msptp = null;
        try {
            msptp = msal.getModelerServicePortTypePort(this.eprModelerRes);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        try {
            msptp = (ModelerServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)msptp, (GCUBEScope)GCUBEScope.getScope((String)Deploy.SCOPE), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VREDescription vreReq = new VREDescription();
        vreReq.setStartTime(Calendar.getInstance());
        vreReq.setEndTime(Calendar.getInstance());
        vreReq.setDescription("Testing VRE");
        vreReq.setDesigner("Andrea");
        vreReq.setManager("Andrea");
        vreReq.setName(this.vreName);
        try {
            msptp.setDescription(vreReq);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        FunctionalityIDArray fida = new FunctionalityIDArray();
        String[] functionalityArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        fida.setFunctionalityIDElement(functionalityArray);
        try {
            msptp.setFunctionality(fida);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        this.prepareCollectionsInfo(msptp);
        GHNArray ghnArray = new GHNArray();
        Deploy.logInfo("Setting GHNs for VRE:\n " + this.ghn1 + "\n" + this.ghn2);
        String id1 = this.query.getGHNId(this.ghn1);
        String id2 = this.query.getGHNId(this.ghn2);
        Deploy.logInfo("With IDs" + id1 + "\n" + id2);
        ghnArray.setGHNElement(new String[]{id1, id2});
        ghnArray.setCandidateGHN(id1);
        try {
            msptp.setGHNs(ghnArray);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw e;
        }
        try {
            msptp.deployVRE(new VOID());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw e;
        }
        Deploy.logInfo("VRE Deployment started\n");
        return msptp;
    }

    private void prepareCollectionsInfo(ModelerServicePortType msptp) {
        CollectionArray coleArr = new CollectionArray();
        CollectionList list = null;
        try {
            list = msptp.getCollection(new VOID());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        ArrayList<String> collectionIds = new ArrayList<String>();
        CollectionType[] collectionTypeArray = list.getList();
        int n = collectionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CollectionType type = collectionTypeArray[n2];
            Deploy.logDebug("Adding collection with ID " + type.getId() + " to VRE");
            collectionIds.add(type.getId());
            ++n2;
        }
        String[] collectionIDS = new String[collectionIds.size()];
        try {
            coleArr.setCollectionElement(collectionIds.toArray(collectionIDS));
            msptp.setCollection(coleArr);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean checkVREResources(ModelerServicePortType porType) {
        QueryInformationSystem queryVRE = null;
        boolean result = true;
        try {
            queryVRE = new QueryInformationSystem(String.valueOf(Deploy.SCOPE) + '/' + this.vreName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            String id = queryVRE.getGenericResourceBySecondaryType("VRE");
            if (id == "") {
                Deploy.logError("The VRE Generic Resource has not been published on the IS");
                result = false;
            } else {
                Deploy.logInfo("The VRE Generic Resource has been correctly published");
                this.resourceIds.add(id);
            }
            id = queryVRE.getGenericResourceBySecondaryType("PortletLayoutResource");
            if (id == "") {
                Deploy.logError("The Available Portlet Generic Resource has not been published on the IS");
                result = false;
            } else {
                Deploy.logInfo("The Available Portlet Generic Resource has been correctly published");
                this.resourceIds.add(id);
            }
            String layoutResourceName = "Layout" + CreateVRE.replaceBackSlash(Deploy.SCOPE) + "_" + this.vreName;
            id = queryVRE.getGenericResourceByName(layoutResourceName);
            if (id == "") {
                Deploy.logError("The VRE Layout Generic Resource has not been published on the IS");
                result = false;
            } else {
                Deploy.logInfo("The VRE Layout Generic Resource has been correctly published");
                this.resourceIds.add(id);
            }
            id = queryVRE.getGenericResourceByName("ScenarioCollectionInfo");
            if (id == "") {
                Deploy.logError("The ScenarioCollectionInfo Generic Resource has not been published on the IS");
                result = false;
            } else {
                Deploy.logInfo("The ScenarioCollectionInfo Generic Resource has been correctly published");
                this.resourceIds.add(id);
            }
        }
        catch (Exception e) {
            Deploy.logError("Error checking Generic Resources Creation", e);
            result = false;
        }
        return result;
    }

    public String getDeploymentReport(EndpointReferenceType epr, String scope, String deploymentId) {
        String report = null;
        try {
            GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return false;
                }
            };
            ReportingPortType pt = (ReportingPortType)GCUBERemotePortTypeContext.getProxy((Remote)new ReportingServiceAddressingLocator().getReportingPortTypePort(epr), (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[]{managerSec});
            report = pt.getReport(deploymentId);
            Deploy.logInfo("REPORT");
            Deploy.logInfo("************");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new StringBufferInputStream(report));
            TransformerFactory ft = TransformerFactory.newInstance();
            Transformer transformer = ft.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setParameter("indent-number", new Integer(4));
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(doc), result);
            Deploy.logInfo(result.getWriter().toString());
            Deploy.logInfo("************");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return report;
    }

    public boolean checkVREStatus(ModelerServicePortType portType) throws Exception {
        String response = null;
        QueryDeploymentInformation info = new QueryDeploymentInformation();
        boolean depResolution = false;
        boolean deployVREstatus = false;
        Deploy.logInfo("Checking the status of the Deployment of the ResourceManager for VRE " + this.vreName);
        long time = System.currentTimeMillis();
        while (!depResolution && System.currentTimeMillis() - time < 600000L) {
            try {
                response = portType.checkStatus(new VOID());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (response == null || response.compareTo("") == 0) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            Deploy.logInfo("Getting first Report: " + response);
            info.parseXml(response);
            try {
                depResolution = info.checkDeploymentInfo(this.query);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            if (depResolution) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        time = System.currentTimeMillis();
        if (depResolution) {
            Deploy.logInfo("The ResourceManager for VRE " + this.vreName + " has been correctly deployed\n");
        } else {
            Deploy.logInfo("The ResourceManager for VRE " + this.vreName + " has not been deployed correctly\n");
        }
        Deploy.logInfo("Checking the deployment status of the VRE Services\n");
        QueryDeploymentInformation infoVRE = new QueryDeploymentInformation();
        while (!deployVREstatus && System.currentTimeMillis() - time < 600000L) {
            try {
                response = portType.checkStatus(new VOID());
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (response == null || response.compareTo("") == 0) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            Deploy.logInfo("Getting second Report: " + response);
            infoVRE.parseXml(response);
            deployVREstatus = infoVRE.checkDeploymentInfo(this.query);
            if (deployVREstatus) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (deployVREstatus) {
            Deploy.logInfo("The VRE Services for VRE " + this.vreName + " have been correctly deployed\n");
        } else {
            Deploy.logInfo("The VRE Services for VRE " + this.vreName + " have not been deployed correctly\n");
        }
        return deployVREstatus && depResolution;
    }

    private String getTextValue(Element ele, String tagName) {
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        block15: {
            checkResources = true;
            deployVREstatus = true;
            portType = null;
            vreName = String.valueOf(args[0]) + "_" + System.currentTimeMillis();
            infoVRE = new QueryDeploymentInformation();
            vre = new CreateVRE(vreName, args[1], args[2], args[4]);
            try {
                portType = vre.createVRE();
            }
            catch (RemoteException e) {
                Deploy.logInfo("Error Creating VRE: " + e);
                infoVRE.writeVREFile("FAILED");
                System.exit(1);
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            try {
                deployVREstatus = vre.checkVREStatus(portType);
                Thread.sleep(20000L);
            }
            catch (Exception e) {
                Deploy.logInfo("Error checking  VRE status: " + e);
                infoVRE.writeVREFile("FAILED");
                System.exit(1);
            }
            checkResources = vre.checkVREResources(portType);
            if (!Boolean.parseBoolean(args[3])) break block15;
            undeployInfo = new QueryDeploymentInformation();
            undeploymentId = null;
            unDeploymentReport = null;
            depResolution = false;
            vreScope = String.valueOf(Deploy.SCOPE) + '/' + vre.vreName;
            is = null;
            try {
                is = new QueryInformationSystem(vreScope);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            time = System.currentTimeMillis();
            if (undeploymentId != null) ** GOTO lbl58
            Deploy.logError("Failed to dispose the VRE scope..");
            break block15;
lbl-1000:
            // 1 sources

            {
                try {
                    unDeploymentReport = vre.getDeploymentReport(is.getResourceManagerEndpoint(), vreScope, undeploymentId);
                    undeployInfo.parseXml(unDeploymentReport);
                    depResolution = undeployInfo.checkUnDeploymentInfo(is);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Deploy.logError("Unable to parse a  UnDeploymentReport", e);
                }
                if (depResolution) continue;
                try {
                    Thread.sleep(60000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
lbl58:
                // 4 sources

                ** while (!depResolution && System.currentTimeMillis() - time.longValue() < 900000L)
            }
        }
        Deploy.logInfo("VRE Deployment test terminated");
        Deploy.logInfo("Deployment service check has returned: " + deployVREstatus);
        Deploy.logInfo("Generic Resource check has returned: " + checkResources);
        if (checkResources && deployVREstatus) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static String replaceBackSlash(String input) {
        return input.replaceAll("\\/", "_");
    }
}

