package org.gcube.deploytest.client;

import java.util.ArrayList;
import java.util.List;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.ISException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISClient.ISMalformedQueryException;
import org.gcube.common.core.informationsystem.client.ISClient.ISUnsupportedQueryException;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBECollectionQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEMCollectionQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEServiceQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.resources.GCUBECollection;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEMCollection;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.scope.GCUBEScope;


/**
 * Creates an instance of ISClient tailored to testing infrastructures 
 * 
 * @author Andrea Manzi(CERN)
 *
 */
public class QueryInformationSystem {
	ISClient client = null;
	GCUBEScope scope = null;

	/**
	 * Default constructor
	 * @throws Exception
	 */
	public QueryInformationSystem () throws Exception {
		client = GHNContext.getImplementation(ISClient.class);//get IS client implementation
		scope = GCUBEScope.getScope(Deploy.SCOPE);

	}


	public QueryInformationSystem (String scope1) throws Exception {
		client = GHNContext.getImplementation(ISClient.class);//get IS client implementation
		scope = GCUBEScope.getScope(scope1);

	}

	/**
	 * Get a service profile given the ServiceInfo object
	 * 
	 * @param info the Service info
	 * @return the GCUBEService profile
	 * @throws Exception
	 */
	public GCUBEService getServiceProfile(ServiceInfo info) throws ISMalformedQueryException, ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {

		GCUBEServiceQuery query = null;

		query = client.getQuery(GCUBEServiceQuery.class);

		query.addAtomicConditions(new AtomicCondition("/Profile/Class",info.get_serviceClass()),
				new AtomicCondition("/Profile/Name",info.get_serviceName()));

		for (GCUBEService profile : client.execute(query,scope))
		{
			return profile;			
		}
		return null;


	}
	
	/**
	 * Get a service profile given the ServiceInfo object
	 * 
	 * @param info the Service info
	 * @return the GCUBEService profile
	 * @throws Exception
	 */
	public GCUBECollection getColProfile(String id ) throws Exception {

		GCUBECollectionQuery query = null;

		query = client.getQuery(GCUBECollectionQuery.class);

		query.addAtomicConditions(new AtomicCondition("/ID",id));

		for (GCUBECollection profile : client.execute(query,scope))
		{
			return profile;			
		}
		return null;


	}
	
	/**
	 * Get a service profile given the ServiceInfo object
	 * 
	 * @param info the Service info
	 * @return the GCUBEService profile
	 * @throws Exception
	 */
	public GCUBEMCollection getMColProfile(String id ) throws Exception {

		GCUBEMCollectionQuery query = null;

		query = client.getQuery(GCUBEMCollectionQuery.class);

		query.addAtomicConditions(new AtomicCondition("/ID",id));

		for (GCUBEMCollection profile : client.execute(query,scope))
		{
			return profile;			
		}
		return null;


	}
	

	/**
	 * Get all Service Profile of the testing infrastructure
	 * @return a list of GCUBE Service profiles
	 */
	public List<GCUBEService> getAllServiceProfile() throws ISMalformedQueryException, ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {

		GCUBEServiceQuery query = null;

		query = client.getQuery(GCUBEServiceQuery.class);	

		return client.execute(query,scope);

	}
	
	/**
	 * Get all GHN of the testing infrastructure
	 * 
	 * @return
	 * @throws Exception

	 */
	public List<GCUBEHostingNode> getAllGHNs() throws ISMalformedQueryException, ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {

		GCUBEGHNQuery query = null;

		query = client.getQuery(GCUBEGHNQuery.class);	

		return client.execute(query,scope);

	}
	
	/**
	 * Get all GHN of the testing infrastructure
	 * 
	 * @return
	 * @throws Exception

	 */
	public List<GCUBEHostingNode> getGHNWithName(String name) throws ISMalformedQueryException, ISUnsupportedQueryException, ISException, InstantiationException, IllegalAccessException {

		GCUBEGHNQuery query = null;

		query = client.getQuery(GCUBEGHNQuery.class);	
		query.addAtomicConditions(new AtomicCondition("/Profile/GHNDescription/Name",name));
		return client.execute(query,scope);

	}


	public List<GCUBEHostingNode> getGHNs() throws ISMalformedQueryException, ISUnsupportedQueryException, ISException{

		GCUBEGHNQuery query = null;
		try {
			query = client.getQuery(GCUBEGHNQuery.class);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return client.execute(query,scope);

	} 

	/**
	 * Get a a GHN Profile id related to its name
	 * @param description the hostame:port of the GHN
	 * @return the GHN Id
	 */
	public String getGHNId(String description)  {

		GCUBEGHNQuery query = null;
		String id = null;
		try {
			query = client.getQuery(GCUBEGHNQuery.class);
		} catch (Exception e) {
			e.printStackTrace();
		}

		query.addAtomicConditions(new AtomicCondition("/Profile/GHNDescription/Name",description));
		try {
			id =client.execute(query,scope).get(0).getID();

		} catch (Exception e) {
			e.printStackTrace();
		}

		return id;
	}

	/**
	 * retrieve the VREModeler port type on the testing infrastructure
	 * @return the VREModeler epr
	 */
	public EndpointReferenceType getVREModelerEndpoint(){

		GCUBERIQuery riquery = null;
		try {
			riquery = client.getQuery(GCUBERIQuery.class);
		} catch (Exception e) {
			e.printStackTrace();
		}


		riquery.addAtomicConditions(new AtomicCondition("//ServiceName", "VREModeler"));

		List<GCUBERunningInstance> results = null;
		try {
			results = client.execute(riquery, scope);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return  results.get(0).getAccessPoint().getEndpoint("gcube/vremanagement/vremodeler/ModelerFactoryService");
	}

	/**
	 * retrieve the VREManager port type on the testing infrastructure
	 * @return the VREManager epr
	 */
	public EndpointReferenceType getVREManagerEndpoint(){

		GCUBERIQuery riquery = null;
		try {
			riquery = client.getQuery(GCUBERIQuery.class);
		} catch (Exception e) {
			e.printStackTrace();
		}


		riquery.addAtomicConditions(new AtomicCondition("//ServiceName", "VREManager"));

		List<GCUBERunningInstance> results = null;
		try {
			results = client.execute(riquery, scope);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return  results.get(0).getAccessPoint().getEndpoint("gcube/vremanagement/VREManager");
	}


	/**
	 * retrieve the ResourceManager port type on the testing infrastructure
	 * @return the ResourceManager epr
	 */
	public EndpointReferenceType getResourceManagerEndpoint(){

		GCUBERIQuery riquery = null;
		try {
			riquery = client.getQuery(GCUBERIQuery.class);
		} catch (Exception e) {

			e.printStackTrace();
		}

		riquery.setExpression("declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry';" +
				" for $outer in collection(\"/db/Profiles/RunningInstance\")//Document/Data/is:Profile/Resource " +
				" let $scope:= $outer/Scopes/Scope[string() eq '"+scope.toString()+"'] " +
				" where count($scope)>0 " +
				" and $outer/Profile/ServiceName/string() eq 'ResourceManager' " +
				" return $outer");


		List<GCUBERunningInstance> results = null;
		try {
			results = client.execute(riquery, scope);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return  results.get(0).getAccessPoint().getEndpoint("gcube/vremanagement/ResourceManager");
	}

	
	/**
	 * retrieve the Registry  port type on the testing infrastructure
	 * @return the Registry epr
	 */
	public EndpointReferenceType getRegistryEndpoint(){

		GCUBERIQuery riquery = null;
		try {
			riquery = client.getQuery(GCUBERIQuery.class);
		} catch (Exception e) {
			e.printStackTrace();
		}


		riquery.addAtomicConditions(new AtomicCondition("//ServiceName", "IS-Registry"));

		List<GCUBERunningInstance> results = null;
		try {
			results = client.execute(riquery, scope);
		} catch (Exception e) {
			e.printStackTrace();
		}

		return  results.get(0).getAccessPoint().getEndpoint("gcube/informationsystem/registry/RegistryFactory");
	}

	
	/**
	 * Get the EPR of a Service running in the given ghniId
	 * @param info a ServiceInfo
	 * @param ghnId the GHNId
	 * @return the EPR
	 */
	public EndpointReferenceType getEndpoint(String serviceName, String serviceClass, String ghnId) {
		EndpointReferenceType epr = null;

		GCUBERIQuery riQuery = null;
		try {
			riQuery = client.getQuery(GCUBERIQuery.class);
		} catch (Exception e) {
			e.printStackTrace();
		}

		riQuery.addAtomicConditions(new AtomicCondition("//ServiceClass",serviceClass),
				new AtomicCondition("//ServiceName",serviceName),
				new AtomicCondition("//GHN/@UniqueID",ghnId));
		try {
			for (GCUBERunningInstance instance : client.execute(riQuery,scope))
			{
				for (Endpoint endpoint : instance.getAccessPoint().getRunningInstanceInterfaces().getEndpoint())
				{
					epr = new EndpointReferenceType();
					epr.setAddress(new AttributedURI(new Address(endpoint.getValue())));
				}
			}
		}  catch (Exception e) {
			e.printStackTrace();
		}

		return epr;
	}

	
	
	/**
	 * Get the ID  of a Service running in the given ghniId
	 * @param info a ServiceInfo
	 * @param ghnId the GHNId
	 * @return the ID
	 */
	public String getRunningInstanceID(String serviceName, String serviceClass, String ghnId) {
		String id = null;

		GCUBERIQuery riQuery = null;
		try {
			riQuery = client.getQuery(GCUBERIQuery.class);
		} catch (Exception e) {
			e.printStackTrace();
		}


		riQuery.addAtomicConditions(new AtomicCondition("//ServiceClass",serviceClass),
				new AtomicCondition("//ServiceName",serviceName),
				new AtomicCondition("//GHN/@UniqueID",ghnId));
		try {
			for (GCUBERunningInstance instance : client.execute(riQuery,scope))
			{
				id = instance.getID();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return id;
	}
	
	/**
	 * Perform a Generic xquery 
	 * @param xquery the xquery to perform
	 * @return a List of result
	 * @throws ISMalformedQueryException
	 * @throws ISUnsupportedQueryException
	 * @throws ISException
	 */
	public List<XMLResult> performGenericQuery(String xquery) throws ISMalformedQueryException, ISUnsupportedQueryException, ISException {
		GCUBEGenericQuery query = null;

		try {
			query = client.getQuery(GCUBEGenericQuery.class);
		} catch (Exception e) {
			e.printStackTrace();
		}

		query.setExpression(xquery);

		return client.execute(query,scope);
	}
	
	/**
	 * Get the Generic Resource given the secondaryType
	 * @param secondaryType the secondary type
	 * @return the ID
	 * @throws Exception

	 */
	public String getGenericResourceBySecondaryType(String secondaryType) throws Exception{
		GCUBEGenericResourceQuery query =  client.getQuery(GCUBEGenericResourceQuery.class);
		query.addAtomicConditions(new AtomicCondition("//SecondaryType",secondaryType));		
		List<GCUBEGenericResource> array = client.execute(query,scope);
		if (array!= null && !(array.isEmpty())) return array.get(0).getID(); 
		else return "";
	}
	
	
	public EndpointReferenceType getWSResourceEpr(String serviceClass, String serviceName, String indexId) throws Exception{
		WSResourceQuery query =  client.getQuery(WSResourceQuery.class);
		query.addAtomicConditions(new AtomicCondition("//ServiceName",serviceName));		
		query.addAtomicConditions(new AtomicCondition("//ServiceClass",serviceClass));
		query.addAtomicConditions(new AtomicCondition("//IndexID",indexId));
		List<RPDocument> array = client.execute(query,scope);
		if (array!= null && !(array.isEmpty())) return array.get(0).getEndpoint(); 
		else return null;
	}
	
	
	/**
	 * Get the Generic Resource given the name
	 * @param name the name
	 * @return ID
		 * @throws Exception

	 */
	public String getGenericResourceByName(String name) throws Exception{
		GCUBEGenericResourceQuery query =  client.getQuery(GCUBEGenericResourceQuery.class);
		query.addAtomicConditions(new AtomicCondition("//Name",name));		
		List<GCUBEGenericResource> array = client.execute(query,scope);
		if (array!= null && !(array.isEmpty())) return array.get(0).getID(); 
		else return "";
		
	}
	/**
	 * Return all the metadatacollections Id
	 * @return the metadatacCollectionIds
	 * @throws Exception exceptions
	 */
	public ArrayList<String>  getMetadataCollectionIds() throws Exception{
		
		ArrayList<String> mcol = new ArrayList<String>();
		
		GCUBEMCollectionQuery query =  client.getQuery(GCUBEMCollectionQuery.class);
		
		List<GCUBEMCollection> array = client.execute(query,scope);
		
		for (GCUBEMCollection mc: array )
		{
			mcol.add(mc.getID());
		}
		return mcol;
		
	}
	
	/**
	 * Return all the metadatacollections 
	 * @return the metadatacCollection
	 * @throws Exception exceptions
	 */
	public List<GCUBEMCollection>  getMetadataCollections() throws Exception{
		GCUBEMCollectionQuery query =  client.getQuery(GCUBEMCollectionQuery.class);		
		return client.execute(query,scope);
		
	}
	
	
	/**
	 * Return all the collections 
	 * @return the Collection
	 * @throws Exception exceptions
	 */
	public List<GCUBECollection>  getCollections() throws Exception{
		GCUBECollectionQuery query =  client.getQuery(GCUBECollectionQuery.class);		
		return client.execute(query,scope);
		
	}
	
	
	/**
	 * Return all the metadatacollections Id
	 * @return the metadatacCollectionIds
	 * @throws Exception exceptions
	 */
	public List<GCUBEGenericResource>  getGenericResources() throws Exception{
		GCUBEGenericResourceQuery query =  client.getQuery(GCUBEGenericResourceQuery.class);		
		return client.execute(query,scope);
		
	}

	/**
	 * 
	 * @param ghnID
	 * @return
	 * @throws Exception
	 */
	public String getGHNName(String ghnID) throws Exception{
		GCUBEGHNQuery query = null;

		query = client.getQuery(GCUBEGHNQuery.class);	
		query.addAtomicConditions(new AtomicCondition("/ID",ghnID));
		GCUBEHostingNode  profile =  client.execute(query,scope).get(0);
		return profile.getNodeDescription().getName();
	}
	
}