/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.deploytest.client;

import java.io.IOException;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.deploytest.client.QueryDeploymentInformation;
import org.gcube.deploytest.client.QueryInformationSystem;
import org.gcube.deploytest.client.ServiceInfo;
import org.gcube.vremanagement.resourcemanager.stubs.binder.AddResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.binder.PackageItem;
import org.gcube.vremanagement.resourcemanager.stubs.binder.RemoveResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceBinderPortType;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceItem;
import org.gcube.vremanagement.resourcemanager.stubs.binder.ResourceList;
import org.gcube.vremanagement.resourcemanager.stubs.binder.SoftwareList;
import org.gcube.vremanagement.resourcemanager.stubs.binder.service.ResourceBinderServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.ReportingPortType;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.service.ReportingServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.ScopeControllerPortType;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.service.ScopeControllerServiceAddressingLocator;
import org.w3c.dom.Document;

public class Deploy {
    protected static Properties resources = new Properties();
    public static String SCOPE = null;
    public static GCUBELog log;
    private long deploymentWaitingTime = 900000L;
    private static QueryInformationSystem isClient;
    private static QueryDeploymentInformation deployInfo;

    static {
        isClient = null;
        deployInfo = null;
    }

    public Deploy(String scope) {
        new Deploy(scope, this.deploymentWaitingTime);
    }

    public Deploy(String scope, long deploymentWaitingTime) {
        try {
            resources.load(Deploy.class.getResourceAsStream("/DeployLogger.properties"));
            SCOPE = scope;
            this.deploymentWaitingTime = deploymentWaitingTime;
            isClient = null;
            try {
                isClient = new QueryInformationSystem();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            deployInfo = new QueryDeploymentInformation();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log = new GCUBEClientLog(Deploy.class, new Properties[]{resources});
    }

    public static void logInfo(String logString) {
        log.info((Object)logString);
    }

    public static void logDebug(String logString) {
        log.debug((Object)logString);
    }

    public static void logError(String logString) {
        log.error((Object)logString);
    }

    public static void logError(String logString, Exception e) {
        log.error((Object)logString, (Throwable)e);
    }

    public static ServiceInfo getServiceNameAndClass(String testName) {
        return new ServiceInfo(testName.substring(testName.indexOf("_") + 1, testName.lastIndexOf("_")), testName.substring(testName.lastIndexOf("_") + 1));
    }

    public static String prepareDeploymentServiceTemplate(String serviceName, String serviceClass, String ghnName, String version) {
        return "numOfServicesToAdd=1\nnumOfResourcesToAdd=0\ntargetScope=" + SCOPE + "\n" + "callerScope=" + SCOPE + "\n" + "service.1.name=" + serviceName + "\n" + "service.1.class=" + serviceClass + "\n" + "service.1.version=" + version + "\n" + "service.1.GHN=" + ghnName + "\n";
    }

    public static String prepareUnDeploymentServiceTemplate(String serviceName, String serviceClass, String version, String ghnName) {
        return "numOfServicesToRemove=1\nnumOfResourcesToRemove=0\ntargetScope=" + SCOPE + "\n" + "callerScope=" + SCOPE + "\n" + "service.1.name=" + serviceName + "\n" + "service.1.class=" + serviceClass + "\n" + "service.1.version=" + version + "\n" + "service.1.GHN=" + ghnName + "\n";
    }

    public boolean isWSRFService(GCUBEService service) {
        for (Package pack : service.getPackages()) {
            if (!(pack instanceof MainPackage)) continue;
            return true;
        }
        return false;
    }

    public String getDeploymentReport(String vreGhnName, String vreGhnPort, String scope, String deploymentId) {
        EndpointReferenceType endpoint = new EndpointReferenceType();
        String report = null;
        try {
            endpoint.setAddress((AttributedURI)new Address("http://" + vreGhnName + ":" + vreGhnPort + "/wsrf/services/gcube/vremanagement/resourcemanager/reporting"));
            GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return false;
                }
            };
            ReportingPortType pt = (ReportingPortType)GCUBERemotePortTypeContext.getProxy((Remote)new ReportingServiceAddressingLocator().getReportingPortTypePort(endpoint), (GCUBEScope)GCUBEScope.getScope((String)scope), (GCUBESecurityManager[])new GCUBESecurityManager[]{managerSec});
            report = pt.getReport(deploymentId);
            log.info((Object)"REPORT");
            log.debug((Object)"************");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new StringBufferInputStream(report));
            TransformerFactory ft = TransformerFactory.newInstance();
            Transformer transformer = ft.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setParameter("indent-number", new Integer(4));
            StreamResult result = new StreamResult(new StringWriter());
            transformer.transform(new DOMSource(doc), result);
            log.info((Object)result.getWriter().toString());
            log.debug((Object)"************");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return report;
    }

    public String deployServices(String vreGhnName, String vreGhnPort, String serviceTemplate) throws GCUBEFault, RemoteException {
        Properties resources = new Properties();
        EndpointReferenceType endpoint = new EndpointReferenceType();
        String deploymentId = null;
        try {
            resources.load(new StringBufferInputStream(serviceTemplate));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
        ResourceBinderPortType pt = null;
        AddResourcesParameters add = new AddResourcesParameters();
        try {
            endpoint.setAddress((AttributedURI)new Address("http://" + vreGhnName + ":" + vreGhnPort + "/wsrf/services/gcube/vremanagement/resourcemanager/binder"));
            GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return false;
                }
            };
            pt = (ResourceBinderPortType)GCUBERemotePortTypeContext.getProxy((Remote)new ResourceBinderServiceAddressingLocator().getResourceBinderPortTypePort(endpoint), (GCUBEScope)GCUBEScope.getScope((String)resources.getProperty("callerScope")), (int)240000, (GCUBESecurityManager[])new GCUBESecurityManager[]{managerSec});
            PackageItem[] packagelist = new PackageItem[new Integer(resources.getProperty("numOfServicesToAdd")).intValue()];
            int i = 1;
            while (i < packagelist.length + 1) {
                packagelist[i - 1] = new PackageItem();
                packagelist[i - 1].setServiceClass(resources.getProperty("service." + i + ".class"));
                packagelist[i - 1].setServiceName(resources.getProperty("service." + i + ".name"));
                packagelist[i - 1].setServiceVersion(resources.getProperty("service." + i + ".version"));
                if (resources.getProperty("service." + i + ".GHN") != null) {
                    packagelist[i - 1].setTargetGHNName(resources.getProperty("service." + i + ".GHN"));
                }
                ++i;
            }
            SoftwareList l = new SoftwareList();
            l.setSoftware(packagelist);
            add.setSoftware(l);
            ResourceItem[] resourcelist = new ResourceItem[new Integer(resources.getProperty("numOfResourcesToAdd")).intValue()];
            int i2 = 1;
            while (i2 < resourcelist.length + 1) {
                resourcelist[i2 - 1] = new ResourceItem();
                resourcelist[i2 - 1].setID(resources.getProperty("resource." + i2 + ".id"));
                resourcelist[i2 - 1].setType(resources.getProperty("resource." + i2 + ".type"));
                ++i2;
            }
            ResourceList r = new ResourceList();
            r.setResource(resourcelist);
            add.setResources(r);
            add.setTargetScope(resources.getProperty("targetScope"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)e);
            return null;
        }
        long time = System.currentTimeMillis();
        do {
            try {
                deploymentId = pt.addResources(add);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            if (deploymentId != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (deploymentId == null && System.currentTimeMillis() - time < this.deploymentWaitingTime);
        if (System.currentTimeMillis() - time > this.deploymentWaitingTime) {
            log.error((Object)"Failed to contact the ResourceManager");
        }
        return deploymentId;
    }

    public String undeployLibraries(String vreGhnName, String vreGhnPort, String serviceTemplate) throws GCUBEFault, RemoteException {
        Properties resources = new Properties();
        EndpointReferenceType endpoint = new EndpointReferenceType();
        String undeploymentId = null;
        try {
            resources.load(new StringBufferInputStream(serviceTemplate));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
        ResourceBinderPortType pt = null;
        RemoveResourcesParameters remove = new RemoveResourcesParameters();
        try {
            endpoint.setAddress((AttributedURI)new Address("http://" + vreGhnName + ":" + vreGhnPort + "/wsrf/services/gcube/vremanagement/resourcemanager/binder"));
            GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return false;
                }
            };
            pt = (ResourceBinderPortType)GCUBERemotePortTypeContext.getProxy((Remote)new ResourceBinderServiceAddressingLocator().getResourceBinderPortTypePort(endpoint), (GCUBEScope)GCUBEScope.getScope((String)resources.getProperty("callerScope")), (int)240000, (GCUBESecurityManager[])new GCUBESecurityManager[]{managerSec});
            PackageItem[] servicelist = new PackageItem[new Integer(resources.getProperty("numOfServicesToRemove")).intValue()];
            int i = 1;
            while (i < servicelist.length + 1) {
                servicelist[i - 1] = new PackageItem();
                servicelist[i - 1].setServiceClass(resources.getProperty("service." + i + ".class"));
                servicelist[i - 1].setServiceName(resources.getProperty("service." + i + ".name"));
                servicelist[i - 1].setServiceVersion(resources.getProperty("service." + i + ".version"));
                if (resources.getProperty("service." + i + ".GHN") != null) {
                    servicelist[i - 1].setTargetGHNName(resources.getProperty("service." + i + ".GHN"));
                }
                ++i;
            }
            SoftwareList l = new SoftwareList();
            l.setSoftware(servicelist);
            remove.setSoftware(l);
            remove.setTargetScope(resources.getProperty("targetScope"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Error creating RemoveLibrary request", (Throwable)e);
            return null;
        }
        long time = System.currentTimeMillis();
        do {
            try {
                undeploymentId = pt.removeResources(remove);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            if (undeploymentId != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (undeploymentId == null && System.currentTimeMillis() - time < this.deploymentWaitingTime);
        if (System.currentTimeMillis() - time > this.deploymentWaitingTime) {
            log.error((Object)"Failed to contact the ResourceManager");
        }
        return undeploymentId;
    }

    public String removeVRE(String vreGhnName, String vreGhnPort, String scope) throws GCUBEFault, RemoteException {
        EndpointReferenceType endpoint = new EndpointReferenceType();
        String undeploymentId = null;
        ScopeControllerPortType pt = null;
        RemoveResourcesParameters remove = new RemoveResourcesParameters();
        try {
            endpoint.setAddress((AttributedURI)new Address("http://" + vreGhnName + ":" + vreGhnPort + "/wsrf/services/gcube/vremanagement/resourcemanager/scopecontroller"));
            GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return false;
                }
            };
            pt = (ScopeControllerPortType)GCUBERemotePortTypeContext.getProxy((Remote)new ScopeControllerServiceAddressingLocator().getScopeControllerPortTypePort(endpoint), (GCUBEScope)GCUBEScope.getScope((String)SCOPE), (int)240000, (GCUBESecurityManager[])new GCUBESecurityManager[]{managerSec});
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"ERROR creating  ResourceManager request for undeployment", (Throwable)e);
            return null;
        }
        long time = System.currentTimeMillis();
        do {
            try {
                undeploymentId = pt.disposeScope(scope);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            if (undeploymentId != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (undeploymentId == null && System.currentTimeMillis() - time < this.deploymentWaitingTime);
        if (System.currentTimeMillis() - time > this.deploymentWaitingTime) {
            log.error((Object)"Failed to contact the ResourceManager");
        }
        return undeploymentId;
    }

    public String undeployServices(String vreGhnName, String vreGhnPort, String serviceTemplate) throws GCUBEFault, RemoteException {
        Properties resources = new Properties();
        EndpointReferenceType endpoint = new EndpointReferenceType();
        String undeploymentId = null;
        try {
            resources.load(new StringBufferInputStream(serviceTemplate));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
        ResourceBinderPortType pt = null;
        RemoveResourcesParameters remove = new RemoveResourcesParameters();
        try {
            endpoint.setAddress((AttributedURI)new Address("http://" + vreGhnName + ":" + vreGhnPort + "/wsrf/services/gcube/vremanagement/resourcemanager/binder"));
            GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return false;
                }
            };
            pt = (ResourceBinderPortType)GCUBERemotePortTypeContext.getProxy((Remote)new ResourceBinderServiceAddressingLocator().getResourceBinderPortTypePort(endpoint), (GCUBEScope)GCUBEScope.getScope((String)SCOPE), (int)240000, (GCUBESecurityManager[])new GCUBESecurityManager[]{managerSec});
            PackageItem[] servicelist = new PackageItem[new Integer(resources.getProperty("numOfServicesToRemove")).intValue()];
            int i = 1;
            while (i < servicelist.length + 1) {
                servicelist[i - 1] = new PackageItem();
                servicelist[i - 1].setServiceClass(resources.getProperty("service." + i + ".class"));
                servicelist[i - 1].setServiceName(resources.getProperty("service." + i + ".name"));
                servicelist[i - 1].setServiceVersion(resources.getProperty("service." + i + ".version"));
                if (resources.getProperty("service." + i + ".GHN") != null) {
                    servicelist[i - 1].setTargetGHNName(resources.getProperty("service." + i + ".GHN"));
                }
                ++i;
            }
            SoftwareList l = new SoftwareList();
            l.setSoftware(servicelist);
            remove.setSoftware(l);
            remove.setTargetScope(resources.getProperty("targetScope"));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"ERROR creating  ResourceManager request for undeployment", (Throwable)e);
            return null;
        }
        long time = System.currentTimeMillis();
        do {
            try {
                undeploymentId = pt.removeResources(remove);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)e);
            }
            if (undeploymentId != null) continue;
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (undeploymentId == null && System.currentTimeMillis() - time < this.deploymentWaitingTime);
        if (System.currentTimeMillis() - time > this.deploymentWaitingTime) {
            log.error((Object)"Failed to contact the ResourceManager");
        }
        return undeploymentId;
    }

    public void undeploy(GCUBEService service, String ghnID, String ghnName, String rmGHNName, String rmGHNPort, String unDeploymentId) throws Exception {
        log.info((Object)"Starting undeployment");
        boolean depResolution = false;
        String unDeploymentReport = null;
        if (service != null && this.isWSRFService(service)) {
            log.debug((Object)("Getting RI ID from IS (" + service.getServiceName() + "," + service.getServiceClass() + "," + ghnID));
            String id = isClient.getRunningInstanceID(service.getServiceName(), service.getServiceClass(), ghnID);
            log.debug((Object)("id=" + id));
            try {
                unDeploymentId = this.undeployServices(rmGHNName, rmGHNPort, Deploy.prepareUnDeploymentServiceTemplate(service.getServiceName(), service.getServiceClass(), service.getVersion(), ghnName));
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                deployInfo.writeFile("FAILED\n");
                System.exit(1);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                deployInfo.writeFile("FAILED\n");
                System.exit(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                deployInfo.writeFile("FAILED\n");
                System.exit(1);
            }
        } else {
            try {
                unDeploymentId = this.undeployLibraries(rmGHNName, rmGHNPort, Deploy.prepareUnDeploymentServiceTemplate(service.getServiceName(), service.getServiceClass(), service.getVersion(), ghnName));
            }
            catch (GCUBEFault e) {
                e.printStackTrace();
                deployInfo.writeFile("FAILED\n");
                System.exit(1);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                deployInfo.writeFile("FAILED\n");
                System.exit(1);
            }
            catch (Exception e) {
                e.printStackTrace();
                deployInfo.writeFile("FAILED\n");
                System.exit(1);
            }
        }
        long time = System.currentTimeMillis();
        while (!depResolution && System.currentTimeMillis() - time < this.deploymentWaitingTime) {
            unDeploymentReport = this.getDeploymentReport(rmGHNName, rmGHNPort, SCOPE, unDeploymentId);
            deployInfo.parseXml(unDeploymentReport);
            depResolution = deployInfo.checkUnDeploymentInfo(isClient);
            if (depResolution) continue;
            Thread.sleep(60000L);
        }
        if (System.currentTimeMillis() - time > this.deploymentWaitingTime) {
            log.error((Object)("Unable to get a Final UnDeploymentReport after " + this.deploymentWaitingTime / 1000L + " sec"));
            deployInfo.writeFile("FAILED\n");
            System.exit(1);
        }
    }

    public String deploy(GCUBEService service, String ghnID, String ghnName, String rmGHNName, String rmGHNPort) throws Exception {
        long time;
        EndpointReferenceType epr = null;
        boolean depResolution = false;
        String deploymentId = null;
        String deploymentReport = null;
        log.info((Object)("Starting the deployment of the SA ( " + service.getServiceClass() + " / " + service.getServiceName() + " ) on GHN " + ghnName));
        try {
            deploymentId = this.deployServices(rmGHNName, rmGHNPort, Deploy.prepareDeploymentServiceTemplate(service.getServiceName(), service.getServiceClass(), ghnName, service.getVersion()));
        }
        catch (GCUBEFault e) {
            e.printStackTrace();
            deployInfo.writeFile("FAILED\n");
            System.exit(1);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            deployInfo.writeFile("FAILED\n");
            System.exit(1);
        }
        if (deploymentId == null) {
            log.error((Object)"Failed to deploy the service due to an error contacting the ResourceManager..");
            deployInfo.writeFile("FAILED\n");
            System.exit(1);
        }
        if (service != null && this.isWSRFService(service)) {
            log.info((Object)"Waiting for the Running Instance publication");
            time = System.currentTimeMillis();
            while ((epr = isClient.getEndpoint(service.getServiceName(), service.getServiceClass(), ghnID)) == null && System.currentTimeMillis() - time < this.deploymentWaitingTime) {
                Thread.sleep(10000L);
                log.debug((Object)"Waiting for the Running Instance publication");
            }
            if (System.currentTimeMillis() - time > this.deploymentWaitingTime) {
                log.error((Object)("Running Instance not yet published on the IS after " + this.deploymentWaitingTime / 1000L + " sec"));
            }
            log.info((Object)"Running Instance retrieved from IS, waiting for deployment report");
            Thread.sleep(60000L);
        } else {
            Thread.sleep(120000L);
        }
        time = System.currentTimeMillis();
        while (!depResolution && System.currentTimeMillis() - time < this.deploymentWaitingTime) {
            try {
                deploymentReport = this.getDeploymentReport(rmGHNName, rmGHNPort, SCOPE, deploymentId);
                deployInfo.parseXml(deploymentReport);
                depResolution = deployInfo.checkDeploymentInfo(isClient);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)"Unable to parse a  DeploymentReport", (Throwable)e);
            }
            if (depResolution) continue;
            Thread.sleep(60000L);
        }
        if (System.currentTimeMillis() - time > this.deploymentWaitingTime) {
            log.error((Object)("Unable to get a Final DeploymentReport after " + this.deploymentWaitingTime / 1000L + " sec"));
            deployInfo.writeFile("FAILED\n");
            System.exit(1);
        }
        return deploymentId;
    }

    public static void main(String[] args) throws Exception {
        String scope = args[0];
        long deploymentWaitingTime = Long.parseLong(args[5]) * 1000L;
        Deploy deploy = new Deploy(scope, deploymentWaitingTime);
        String testName = args[1];
        String ghnID = args[2];
        String rmGHNName = args[3];
        String rmGHNPort = args[4];
        String unDeploymentId = null;
        String ghnName = null;
        GCUBEService service = null;
        try {
            service = isClient.getServiceProfile(Deploy.getServiceNameAndClass(testName));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Error querying the IS to get SA information", (Throwable)e);
            deployInfo.writeFile("FAILED\n");
            System.exit(1);
        }
        if (service == null) {
            log.error((Object)("The Service Profile related to the SA " + Deploy.getServiceNameAndClass(testName).get_serviceClass() + " / " + Deploy.getServiceNameAndClass(testName).get_serviceName() + ", is not published on the IS\n" + " The deployment cannot be performed\n"));
            deployInfo.writeFile("FAILED\n");
            System.exit(1);
        }
        log.debug((Object)("ghnID is: \"" + ghnID + "\""));
        try {
            ghnName = isClient.getGHNName(ghnID);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Error querying the IS to get GHN information", (Throwable)e);
            deployInfo.writeFile("FAILED\n");
            System.exit(1);
        }
        unDeploymentId = deploy.deploy(service, ghnID, ghnName, rmGHNName, rmGHNPort);
        deploy.undeploy(service, ghnID, ghnName, rmGHNName, rmGHNPort, unDeploymentId);
    }
}

