/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.deploytest.client;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.Software;
import org.gcube.deploytest.client.Deploy;
import org.gcube.deploytest.client.QueryInformationSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueryDeploymentInformation {
    Document dom;

    public void parseXmlFile(String file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(file);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void parseXml(String xml) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.dom = db.parse(new StringBufferInputStream(xml));
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public String getDependenciesResolutionStatus() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("DependenciesResolutionStatus");
        String textVal = null;
        if (nl != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Element el = (Element)nl.item(i);
                textVal = el.getFirstChild().getNodeValue();
                ++i;
            }
        }
        return textVal;
    }

    public boolean getDeploymentActivityStatus() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("LastReportReceived");
        if (nl != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                Node statuses = nl.item(i);
                NodeList children = statuses.getChildNodes();
                String status = null;
                int k = 0;
                while (k < children.getLength()) {
                    if (children.item(k) instanceof Element && ((Element)children.item(k)).getTagName().equals("Status")) {
                        status = ((Element)children.item(k)).getTextContent();
                        Deploy.logInfo("The Deployment status is: " + status);
                        if (status.equals("FAILED")) {
                            Deploy.logInfo("\nThe undeploment has failed\n");
                            this.writeFile("FAILED\n");
                            System.exit(1);
                        } else if (status.equals("OPEN")) {
                            return false;
                        }
                    }
                    ++k;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private NodeList getServices() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("Service");
        return nl;
    }

    private NodeList getResources() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("Resource");
        return nl;
    }

    private NodeList getPackagesDeployed() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("Package");
        return nl;
    }

    private boolean getDeploymentPlanCreation() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("DeploymentPlanCreation");
        String status = "";
        String message = "";
        if (nl != null && nl.getLength() > 0) {
            int i = 0;
            while (i < nl.getLength()) {
                if (nl.item(i) instanceof Element) {
                    if (((Element)nl.item(i)).getTagName().equals("Status")) {
                        status = ((Element)nl.item(i)).getTextContent();
                    }
                    if (((Element)nl.item(i)).getTagName().equals("Message")) {
                        message = ((Element)nl.item(i)).getTextContent();
                    }
                }
                ++i;
            }
        }
        if (status.equals("FAILED")) {
            Deploy.logError("The following error has been encountered: " + message);
            return false;
        }
        return true;
    }

    public Package getPackage(GCUBEService service, String packageName) {
        for (Package pack : service.getPackages()) {
            if (!pack.getName().equals(packageName)) continue;
            return pack;
        }
        return null;
    }

    public ArrayList<String> getFileList(Package service) {
        ArrayList<String> files = new ArrayList<String>();
        if (service instanceof Software) {
            for (String file : ((Software)service).getFiles()) {
                int index = file.lastIndexOf("/");
                if (index != -1) {
                    file = file.substring(index + 1);
                }
                files.add(file);
            }
        }
        return files;
    }

    private NodeList getLastReportReceived() {
        Element docEle = this.dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("Status");
        return nl;
    }

    public void writeFile(String status) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("deployment_status"));
            out.write(status);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeVREFile(String status) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter("vre_status"));
            out.write(status);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean parseResources(NodeList resources) {
        boolean finalStatus = true;
        int i = 0;
        while (i < resources.getLength()) {
            Node resource = resources.item(i);
            if (resource != null) {
                NodeList children = resource.getChildNodes();
                String ID = null;
                String Type2 = null;
                String status = null;
                int k = 0;
                while (k < children.getLength()) {
                    if (children.item(k) instanceof Element) {
                        if (((Element)children.item(k)).getTagName().equals("ID")) {
                            ID = ((Element)children.item(k)).getTextContent();
                        } else if (((Element)children.item(k)).getTagName().equals("Type")) {
                            Type2 = ((Element)children.item(k)).getTextContent();
                        } else if (((Element)children.item(k)).getTagName().equals("Status")) {
                            status = ((Element)children.item(k)).getTextContent();
                        }
                    }
                    ++k;
                }
                Deploy.logInfo("Resource with ID " + ID);
                Deploy.logInfo("with Type " + Type2);
                Deploy.logInfo("has been processed with status " + status);
                if (status.equals("FAILED")) {
                    finalStatus = false;
                }
            }
            ++i;
        }
        return finalStatus;
    }

    private boolean parseDependenciesResolutionStatus(NodeList services) {
        boolean finalStatus = true;
        int i = 0;
        while (i < services.getLength()) {
            Node service = services.item(i);
            if (service != null) {
                NodeList children = service.getChildNodes();
                String clazz = null;
                String name = null;
                String status = null;
                String errorDesc = null;
                int k = 0;
                while (k < children.getLength()) {
                    if (children.item(k) instanceof Element) {
                        if (((Element)children.item(k)).getTagName().equals("Class")) {
                            clazz = ((Element)children.item(k)).getTextContent();
                        } else if (((Element)children.item(k)).getTagName().equals("Name")) {
                            name = ((Element)children.item(k)).getTextContent();
                        } else if (((Element)children.item(k)).getTagName().equals("DependenciesResolutionStatus")) {
                            status = ((Element)children.item(k)).getTextContent();
                        } else if (((Element)children.item(k)).getTagName().equals("ErrorDescription")) {
                            errorDesc = ((Element)children.item(k)).getTextContent();
                        }
                    }
                    ++k;
                }
                Deploy.logInfo("Dependency Resolution for Service " + clazz + "/" + name);
                Deploy.logInfo("has been processed with status " + status);
                if (status.equals("FAILED")) {
                    Deploy.logInfo("The following error has been encountered: " + errorDesc);
                    finalStatus = false;
                }
            }
            ++i;
        }
        return finalStatus;
    }

    private void checkPackagesDeployment(NodeList packages, boolean isDeployment) {
        int i = 0;
        while (i < packages.getLength()) {
            Node pack = packages.item(i);
            if (pack != null) {
                NodeList children = pack.getChildNodes();
                String serviceName = null;
                String serviceClass = null;
                String status = null;
                String packageName = null;
                Object service = null;
                int k = 0;
                while (k < children.getLength()) {
                    if (children.item(k) instanceof Element) {
                        if (((Element)children.item(k)).getTagName().equals("ServiceClass")) {
                            serviceClass = ((Element)children.item(k)).getTextContent();
                        } else if (((Element)children.item(k)).getTagName().equals("ServiceName")) {
                            serviceName = ((Element)children.item(k)).getTextContent();
                        } else if (((Element)children.item(k)).getTagName().equals("PackageName")) {
                            packageName = ((Element)children.item(k)).getTextContent();
                        } else if (((Element)children.item(k)).getTagName().equals("Status")) {
                            status = ((Element)children.item(k)).getTextContent();
                        }
                    }
                    ++k;
                }
                if (isDeployment) {
                    if (!(status.equals("REGISTERED") || status.equals("ACTIVATED") || status.equals("NOTVERIFIED") || status.equals("RUNNING") || status.equals("ALREADYDEPLOYED"))) {
                        Deploy.logError("\nFAILED - The Software package (" + serviceClass + "/" + serviceName + "/" + packageName + ") has not been corretly deployed and activated (status is:\"" + status + "\")\n");
                        this.writeFile("FAILED\n");
                        System.exit(1);
                    }
                } else if (!(status.equals("UNDEPLOYED") || status.equals("NOTVERIFIED") || status.equals("NOTUNDEPLOYABLE"))) {
                    this.writeFile("FAILED\n");
                    Deploy.logError("\nFAILED - The  package (" + serviceClass + "/" + serviceName + "/" + packageName + ") has not been undeployed \n");
                    System.exit(1);
                }
            }
            ++i;
        }
    }

    public boolean checkDeploymentInfo(QueryInformationSystem isClient) throws Exception {
        NodeList ns;
        NodeList nl = this.getResources();
        if (nl == null) {
            Deploy.logInfo("\nThe deploment is still ongoing\n");
            return false;
        }
        if (!this.parseResources(nl)) {
            Deploy.logInfo("\nThe deploment has failed\n");
            this.writeFile("FAILED\n");
            System.exit(1);
        }
        if (!this.getDeploymentPlanCreation()) {
            Deploy.logInfo("\nThe deploment has failed\n");
            this.writeFile("FAILED\n");
            System.exit(1);
        }
        if ((ns = this.getServices()) == null) {
            Deploy.logInfo("\nThe deploment is still ongoing\n");
            return false;
        }
        if (!this.parseDependenciesResolutionStatus(ns)) {
            Deploy.logInfo("\nThe deploment has failed beacuse one/more dependency failed to be resolved\n");
            this.writeFile("FAILED\n");
            System.exit(1);
        }
        if (this.getDeploymentActivityStatus()) {
            this.checkPackagesDeployment(this.getPackagesDeployed(), true);
            Deploy.logInfo("\nSUCCESS - All packages correctly deployed or activated\n");
            return true;
        }
        Deploy.logInfo("\nThe deploment is still ongoing\n");
        return false;
    }

    public boolean checkUnDeploymentInfo(QueryInformationSystem isClient) {
        NodeList ns;
        NodeList nl = this.getResources();
        if (nl == null) {
            Deploy.logInfo("\nThe undeploment is still ongoing\n");
            return false;
        }
        if (!this.parseResources(nl)) {
            Deploy.logInfo("\nThe undeploment has failed\n");
            this.writeFile("FAILED\n");
            System.exit(1);
        }
        if ((ns = this.getServices()) == null) {
            Deploy.logInfo("\nThe undeploment is still ongoing\n");
            return false;
        }
        if (!this.getDeploymentActivityStatus()) {
            Deploy.logInfo("\nThe deploment is still ongoing\n");
            return false;
        }
        this.checkPackagesDeployment(this.getPackagesDeployed(), false);
        this.writeFile("SUCCESS\n");
        Deploy.logInfo("\nSUCCESS - All packages correctly undeployed\n");
        System.exit(0);
        return true;
    }

    public boolean checkSoftwareDeployment(ArrayList<String> files) {
        boolean isSoftPresent = true;
        if (files == null) {
            Deploy.logInfo("No deployment files to check");
            return true;
        }
        for (String file : files) {
            if (new File(String.valueOf(System.getenv("GLOBUS_LOCATION")) + "/lib/" + file).exists()) {
                Deploy.logInfo(String.valueOf(file) + " file has been correctly deployed");
                continue;
            }
            Deploy.logError(String.valueOf(file) + " IS MISSING!!");
            isSoftPresent = false;
        }
        return isSoftPresent;
    }
}

