/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextraction.dummy.workflow.engine.functionality;

import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.is.InformationSystem;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.gcube.execution.workflowengine.service.stubs.AccessInfo;
import org.gcube.execution.workflowengine.service.stubs.JDLConfig;
import org.gcube.execution.workflowengine.service.stubs.JDLParams;
import org.gcube.execution.workflowengine.service.stubs.JDLResource;
import org.gcube.execution.workflowengine.service.stubs.JobOutput;
import org.gcube.execution.workflowengine.service.stubs.StatusReport;
import org.gcube.execution.workflowengine.service.stubs.StatusRequest;
import org.gcube.execution.workflowengine.service.stubs.WorkflowEngineServicePortType;
import org.gcube.textextraction.exceptions.JobStatusRetrievalException;
import org.gcube.textextraction.exceptions.NoScriptFoundException;
import org.gcube.textextraction.exceptions.NoWorkflowEngineEPRFound;
import org.gcube.textextraction.exceptions.NodeWithTextExtractionSoftwareNotFoundException;
import org.gcube.textextraction.exceptions.WorkflowEnginePortTypeException;
import org.gcube.textextraction.utils.ServiceUtils;

public class WEClient {
    public static void main(String[] args) throws WorkflowEnginePortTypeException, EnvironmentInformationSystemException, IOException, NoScriptFoundException, NodeWithTextExtractionSoftwareNotFoundException, NoWorkflowEngineEPRFound {
        String status;
        WorkflowEngineServicePortType wf;
        String endpoint;
        String outReference;
        String outAccess;
        AccessInfo ftpAccess;
        String mainClass = args[0];
        String servletURI = args[1];
        String queryToSubmit = args[2];
        String ftpHost = args[3];
        String ftpFolder = args[4];
        String scope = args[5];
        String dtsInputCollectionId = args[6];
        String ftpUser = args[7];
        String ftpPassword = args[8];
        String ftpPort = args[9];
        String suggestedDTSEpr = args[10];
        String suggestedOCREpr = args[11];
        JDLParams params = new JDLParams();
        JDLConfig conf = new JDLConfig();
        conf.setChokePerformanceEvents(true);
        conf.setChokeProgressEvents(true);
        params.setConfig(conf);
        JDLResource r = null;
        ArrayList<JDLResource> resourceslst = null;
        EnvHintCollection Hints = new EnvHintCollection();
        Hints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(scope)));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorCount", new EnvHint("4")));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorInterval", new EnvHint("5000")));
        System.out.println("Initializing Information System");
        try {
            InformationSystem.Init((String)"gr.uoa.di.madgik.environment.gcube.GCubeInformationSystemProvider", (EnvHintCollection)Hints);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Hints = new EnvHintCollection();
        System.out.println("The scope is: " + scope);
        Hints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(scope)));
        if (InformationSystem.GetMatchingNode(null, (String)"software.textextraction == true", (EnvHintCollection)Hints) == null) {
            System.out.println("It is null!");
        }
        if (InformationSystem.GetMatchingNode(null, (String)"software.ocropus == true", (EnvHintCollection)Hints) == null) {
            System.out.println("It is null too!!");
        } else {
            System.out.println("Are you kidding me??");
        }
        if (InformationSystem.GetMatchingNode(null, (String)"software.textextraction == true", (EnvHintCollection)Hints) != null) {
            System.out.println("A node with TextExtractionJob was found in scope: " + scope);
            ftpAccess = new AccessInfo();
            outAccess = "CMSReference";
            outReference = "";
            ftpAccess.setPassword(ftpPassword.trim());
            ftpAccess.setPort(ftpPort);
            ftpAccess.setUserId(ftpUser.trim());
            outAccess = "Reference";
            outReference = ftpFolder + "/jobsOutput";
            String jdlDescription = "[\nType = \"Job\";\nJobType = \"Normal\";\nExecutable = \"textExtractionJob.sh\";\nArguments = \"\"" + mainClass.replaceAll("//", "__") + " " + servletURI.replaceAll("//", "__") + " " + queryToSubmit.replaceAll("//", "__").replaceAll(" ", "#") + " " + ftpHost.replaceAll("//", "__") + " " + ftpFolder.replaceAll("//", "__") + " " + scope.replaceAll("//", "__") + " " + dtsInputCollectionId.replaceAll("//", "__") + " " + ftpUser.replaceAll("//", "__") + " " + ftpPassword.replaceAll("//", "__") + " " + ftpPort.replaceAll("//", "__") + "\" " + suggestedDTSEpr.replaceAll("//", "__") + " " + suggestedOCREpr.replaceAll("//", "__") + "\"; " + "StdOutput = \"job.out\";\n" + "StdError = \"job.err\";\n" + "VirtualOrganisation = \"d4science.research-infrastructures.eu\";\n" + "InputSandbox = {" + "\"textExtractionJob.sh\"};\n" + "OutputSandbox = {\"job.out\", \"job.err\"};\n" + "Environment = {\"CLASSPATH=$GLOBUS_LOCATION/lib\"};\n" + "Requirements = software.textextraction == true  ;\n" + "]\n";
            System.out.println("------> Sed jdl of TextExtraction job: \n" + jdlDescription);
            params.setJdlDescription(jdlDescription);
            resourceslst = new ArrayList<JDLResource>();
            String textExtractionJobShFileName = System.getenv("GLOBUS_LOCATION") + "/textExtractionJob.sh";
            System.out.println("Looking for file: " + textExtractionJobShFileName);
            if (!ServiceUtils.fileExists(textExtractionJobShFileName)) {
                throw new NoScriptFoundException("textExtractionJob.sh script must exist under " + System.getenv("GLOBUS_LOCATION"));
            }
            r = new JDLResource();
            r.setResourceKey("textExtractionJob.sh");
            r.setResourceAccess("InMessageString");
            r.setInMessageStringPayload(ServiceUtils.GetStringFilePayload(textExtractionJobShFileName));
            resourceslst.add(r);
        } else {
            throw new NodeWithTextExtractionSoftwareNotFoundException("No node with textExtraction software found for this scope!");
        }
        r = new JDLResource();
        r.setResourceType("OutData");
        r.setResourceAccess(outAccess);
        r.setResourceReference(outReference);
        r.setResourceKey("job.out");
        r.setResourceAccessInfo(ftpAccess);
        resourceslst.add(r);
        r = new JDLResource();
        r.setResourceType("OutData");
        r.setResourceAccess(outAccess);
        r.setResourceReference(outReference);
        r.setResourceKey("job.err");
        r.setResourceAccessInfo(ftpAccess);
        resourceslst.add(r);
        JDLResource[] jdlResourceArray = new JDLResource[resourceslst.size()];
        params.setJdlResources(resourceslst.toArray(jdlResourceArray));
        for (int p = 0; p < params.getJdlResources().length; ++p) {
            System.out.println(" Resource " + p + " Key:" + params.getJdlResources()[p].getResourceKey() + " Access:" + params.getJdlResources()[p].getResourceAccess() + " Ref:" + params.getJdlResources()[p].getResourceReference() + " String:" + params.getJdlResources()[p].getInMessageStringPayload());
        }
        System.out.println("Locating Workflow Engine to submit TextExtraction job");
        String Scope = scope;
        try {
            endpoint = ServiceUtils.GetWorkflowEngineEndpoint(Scope);
        }
        catch (Exception e) {
            System.out.println("Now WorkflowEngine epr found.");
            e.printStackTrace();
            throw new NoWorkflowEngineEPRFound(e);
        }
        System.out.println("Selected Workflow Engine for TextExtraction job: " + endpoint);
        System.out.println("Submitting TextExtraction job to Workflow Engine (scope:" + scope + " , endpoint:" + endpoint);
        try {
            wf = ServiceUtils.GetWorkflowEnginePortType(Scope, endpoint);
        }
        catch (Exception e) {
            System.out.println("Problem when retrieving WorkFlowEnginePortType");
            e.printStackTrace();
            throw new WorkflowEnginePortTypeException(e);
        }
        String executionId = wf.adaptJDL(params);
        System.out.println("Submitted TextExtraction job successfully  (ExecutionId: " + executionId + " Scope: " + Scope + " WFE Endpoint: " + endpoint + ")");
        do {
            try {
                System.out.println("OCRStatusPoller is going to sleep for 25000 ms");
                Thread.sleep(25000L);
            }
            catch (InterruptedException e1) {
                System.out.println("Error while ocr poller was preparing to sleep");
                e1.printStackTrace();
            }
            try {
                status = WEClient.getJobStatus(executionId, scope, endpoint);
            }
            catch (WorkflowEnginePortTypeException e1) {
                System.out.println("Error while retrieving status for job: " + executionId + " endpoint: " + endpoint);
                e1.printStackTrace();
                status = "TORESUBMIT";
            }
            catch (JobStatusRetrievalException e1) {
                System.out.println("Error while retrieving status for job: " + executionId + " endpoint: " + endpoint);
                status = "TORESUBMIT";
                e1.printStackTrace();
            }
            System.out.println("CHECKING JOB STATUS: " + executionId + " " + status);
        } while (!status.equals("COMPLETED"));
    }

    public static String getJobStatus(String executionId, String scope, String engineUrl) throws WorkflowEnginePortTypeException, JobStatusRetrievalException {
        WorkflowEngineServicePortType wf;
        try {
            System.out.println("getJobStatus scope:" + scope + " executionId: " + executionId);
            wf = ServiceUtils.GetWorkflowEnginePortType(scope, engineUrl);
        }
        catch (Exception e) {
            System.out.println("Error while getting WorkflowEnginePortType to poll status of OCR job");
            e.printStackTrace();
            throw new WorkflowEnginePortTypeException(e);
        }
        StatusRequest req = new StatusRequest();
        req.setExecutionID(executionId);
        req.setIncludePlan(Boolean.valueOf(false));
        StatusReport rep = null;
        try {
            rep = wf.executionStatus(req);
        }
        catch (RemoteException e) {
            System.out.println("Error while asking status of job: " + executionId);
            e.printStackTrace();
            throw new JobStatusRetrievalException(e);
        }
        if (rep.isIsCompleted()) {
            if (rep.getError() != null && !rep.getError().equals("") || rep.getErrorDetails() != null && !rep.getErrorDetails().equals("")) {
                System.out.println("JOB_FINISHED WITH ERROR: " + rep.getError());
            }
            for (JobOutput jo : rep.getOutput()) {
                if (jo.getKey() == null || jo.getKey().trim().length() <= 0) continue;
                if (jo.getKey().equals("job.out")) {
                    System.out.println("The job out is: " + jo.getStorageSystemID());
                    continue;
                }
                if (!jo.getKey().equals("job.err")) continue;
                System.out.println("The job error is: " + jo.getStorageSystemID());
            }
            return "COMPLETED";
        }
        if (rep.getError() != null && !rep.getError().equals("") || rep.getErrorDetails() != null && !rep.getErrorDetails().equals("")) {
            System.out.println("JOB_FINISHED WITH ERROR: " + rep.getError() + " " + rep.getErrorDetails());
        } else if (rep.getError() != null) {
            System.out.println("ERRORrr: " + rep.getError());
        }
        return "RUNNING";
    }
}

