/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.report.configurations;

import it.eng.d4s.sa3.model.Build;
import it.eng.d4s.sa3.report.ReportException;
import it.eng.d4s.sa3.repository.resourcetype.BuildResourceType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationsReport {
    Document doc = null;
    File file = null;

    public static ConfigurationsReport init(File file) throws TransformerException, ParserConfigurationException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("Configurations");
        doc.appendChild(rootElement);
        ConfigurationsReport d = new ConfigurationsReport();
        d.doc = doc;
        d.file = file;
        return d;
    }

    public static ConfigurationsReport load(File file) throws ParserConfigurationException, SAXException, IOException {
        ConfigurationsReport d = new ConfigurationsReport();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        d.doc = dBuilder.parse(file);
        d.file = file;
        return d;
    }

    public static ConfigurationsReport getInstance(Build b) throws ReportException {
        try {
            if (b.getRepo().existsBResource(BuildResourceType.B_CONFIGURATIONS_REPORT)) {
                InputStream is = b.getRepo().getBResourceIS(BuildResourceType.B_CONFIGURATIONS_REPORT);
                ConfigurationsReport d = new ConfigurationsReport();
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                d.doc = dBuilder.parse(is);
                d.file = null;
                return d;
            }
            throw new ReportException("configurations_report.xml not found for build " + b);
        }
        catch (Exception e) {
            throw new ReportException("Error loading configurationReport for build " + b);
        }
    }

    public void addEntry(String configuration, String status) {
        Element node = this.doc.createElement("configuration");
        node.setAttribute("name", configuration);
        node.setAttribute("status", status);
        Node configurationNode = this.doc.getFirstChild();
        configurationNode.appendChild(node);
    }

    public List<String> getAllConfigurationsName() throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        LinkedList<String> list = new LinkedList<String>();
        NodeList nodes = (NodeList)xPath.evaluate("/Configurations/configuration", this.doc, XPathConstants.NODESET);
        int j = 0;
        while (j < nodes.getLength()) {
            Node n = nodes.item(j);
            NamedNodeMap attrs = n.getAttributes();
            list.add(attrs.getNamedItem("name").getNodeValue());
            ++j;
        }
        return list;
    }

    public List<String> getUnlockedConfigurationsByNameContains(String nameContains) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        NodeList nodes = (NodeList)xPath.evaluate("/Configurations/configuration[contains(./@name,'" + nameContains + "')]", this.doc, XPathConstants.NODESET);
        LinkedList<String> list = new LinkedList<String>();
        int j = 0;
        while (j < nodes.getLength()) {
            Node n = nodes.item(j);
            NamedNodeMap attrs = n.getAttributes();
            if (attrs.getNamedItem("status").getNodeValue().equals("")) {
                list.add(attrs.getNamedItem("name").getNodeValue());
            }
            ++j;
        }
        return list;
    }

    public String getConfigurationStatus(String configuration) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        Node node = (Node)xPath.evaluate("/Configurations/configuration[./@name='" + configuration + "']", this.doc, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        NamedNodeMap attrs = node.getAttributes();
        return attrs.getNamedItem("status").getNodeValue();
    }

    public void save() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "8");
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult("file://" + this.file.getAbsolutePath());
        transformer.transform(source, result);
    }
}

