package org.gcube.common.mycontainer;

import javax.xml.namespace.QName;

import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferenceParametersType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.utils.AnyHelper;
import org.oasis.wsrf.properties.QueryExpressionType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.QueryResourceProperties_PortType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;

/**
 * Test utilities for in-container tests
 * 
 * @author Fabio Simeoni
 *
 */
public class MyContainerUtils extends MyContainer {

	/**
	 * Extract the key of a service instance from a reference to the instance.
	 * @param reference a reference to the instance
	 * @param namespace the namespace of the service
	 * @return the key
	 */
	public static String keyOf(EndpointReferenceType reference, String namespace) {
		ReferencePropertiesType properties = reference.getProperties(); 
		
		if (properties == null)
			return null;
		
		MessageElement element = properties.get(new QName(namespace,"ResourceKey"));
		
		if (element == null)
			return null;
		
		return element.getValue();
	}
}
