package org.gcube.common.mycontainer;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.globus.wsrf.WSRFConstants;
import org.oasis.wsrf.properties.QueryExpressionType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.QueryResourceProperties_PortType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Simple XPath evaluator over resource property documents.
 * 
 * @author Fabio Simeoni
 *
 */
public class ResourcePropertyHelper {

	/** XPath engine. */;
	private static XPathFactory factory = XPathFactory.newInstance();
	
	private XPath engine = factory.newXPath();
	
	private Map<String,String> namespaces = new HashMap<String,String>();
	
	private NamespaceContext nsContext = new NamespaceContext() {
        
		public String getNamespaceURI(String prefix) {
			return namespaces.get(prefix);
        }
       
        public Iterator<?> getPrefixes(String val) {
        	return null;
        }
       
        public String getPrefix(String uri) {
        	return null;
        }
    };
	
	/** Transformation engine. */
	private static Transformer transformer;

	static {
		try {
			transformer = TransformerFactory.newInstance().newTransformer();
			transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,"yes");
		}
		catch(Exception e) {
			throw new RuntimeException(e);
		}
	}
	
	private final Node document;

	/**
	 * Creates an instance with a reference to a service instance.
	 * @param reference the reference
	 */
	public ResourcePropertyHelper(EndpointReferenceType reference) {
		
		try {
			this.document= propertiesOf(reference).get_any()[0].getAsDOM();
		}
		catch(Exception e) {
			throw new RuntimeException(e);
		}
		
		engine.setNamespaceContext(nsContext);
	}
	
	/**
	 * Declares a namespace for XPath evaluation. 
	 * @param prefix the namespace prefix
	 * @param uri the namespace URI
	 */
	public void addNamespace(String prefix,String uri) {
		namespaces.put(prefix,uri);
	}
	
	/**
	 * Evaluates an XPath expression and returns matching values as strings.
	 * @param xpath the expression
	 * @return the list matching values
	 */
	public String show() {
		return evaluate("/").get(0);
	}
	/**
	 * Evaluates an XPath expression and returns matching values as strings.
	 * @param xpath the expression
	 * @return the list matching values
	 */
	public List<String> evaluate(String xpath) {
		
		List<String> results = new ArrayList<String>();
		
		try {
			
			NodeList set = evaluateForNodes(xpath);
			
			for (int i=0;i<set.getLength();i++) {
				StreamResult sr = new StreamResult(new StringWriter());
				transformer.transform(new DOMSource(set.item(i)),sr);
				results.add(sr.getWriter().toString());
			}
		
			return results;
			
		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
	 * Evaluates an XPath expression and returns matching values as a {@link NodeList}.
	 * @param xpath the expression
	 * @return the list matching values
	 */
	public NodeList evaluateForNodes(String xpath) {
		
		try {			
			return (NodeList) engine.evaluate(xpath,document, XPathConstants.NODESET);

		}
		catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
	
public static QueryResourcePropertiesResponse propertiesOf(EndpointReferenceType reference) {
		
		try {

			String dialect = WSRFConstants.XPATH_1_DIALECT;
			String expression = "/";

			WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();

			QueryExpressionType query = new QueryExpressionType();
			query.setDialect(dialect);
			query.setValue(expression);

			QueryResourceProperties_PortType port = locator.getQueryResourcePropertiesPort(reference);

			// client.setOptions((Stub)port);

			QueryResourceProperties_Element request = new QueryResourceProperties_Element();
			request.setQueryExpression(query);

			QueryResourcePropertiesResponse response = port.queryResourceProperties(request);

			if (response == null || response.get_any() == null || response.get_any().length == 0)
				throw new Exception("could not access ws resource");

			return response;
			
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}
