/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.resourcemanager.util;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.Plugin;
import org.gcube.common.core.resources.service.Software;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.tools.resourcemanager.util.QueryInformationSystem;
import org.gcube.tools.resourcemanager.util.ServiceInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ParseDeploymentInformation {
    Document dom;
    GCUBELog logger = null;
    QueryInformationSystem isClient = null;
    boolean globaloperationStatus = true;

    public ParseDeploymentInformation(QueryInformationSystem queryInformationSystem, GCUBELog gCUBELog) {
        this.logger = gCUBELog;
        this.isClient = queryInformationSystem;
    }

    public boolean isGlobaloperationStatus() {
        return this.globaloperationStatus;
    }

    public void setGlobaloperationStatus(boolean bl) {
        this.globaloperationStatus = bl;
    }

    public void parseXml(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.dom = documentBuilder.parse(new InputSource(new StringReader(string)));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getDependenciesResolutionStatus() {
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("DependenciesResolutionStatus");
        String string = null;
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                string = element2.getFirstChild().getNodeValue();
            }
        }
        return string;
    }

    public boolean getDeploymentActivityStatus() {
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("LastReportReceived");
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NodeList nodeList2 = node.getChildNodes();
                String string = null;
                String string2 = null;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    if (!(nodeList2.item(j) instanceof Element)) continue;
                    if (((Element)nodeList2.item(j)).getTagName().equals("Status")) {
                        string = ((Element)nodeList2.item(j)).getTextContent();
                        this.logger.info((Object)("The Deployment status is: " + string));
                        if (string.equals("FAILED")) {
                            this.logger.error((Object)"The undeploment has failed\n");
                        } else if (string.equals("OPEN")) {
                            return false;
                        }
                    }
                    if (!((Element)nodeList2.item(j)).getTagName().equals("ErrorDescription")) continue;
                    string2 = ((Element)nodeList2.item(j)).getTextContent();
                    this.logger.error((Object)("Error Description :" + string2));
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private NodeList getServices() {
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("Service");
        return nodeList;
    }

    private String getGlobalStatus() {
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2;
            if (!(nodeList.item(i) instanceof Element) || (element2 = (Element)nodeList.item(i)).getTagName().compareTo("Status") != 0) continue;
            this.logger.info((Object)("The global status is " + element2.getTextContent()));
            return element2.getTextContent();
        }
        return "";
    }

    private NodeList getResources() {
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("Resource");
        return nodeList;
    }

    private NodeList getPackagesDeployed() {
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("GHN");
        return nodeList;
    }

    private boolean getDeploymentPlanCreation() {
        Element element = this.dom.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("DeploymentPlanCreation");
        String string = "";
        String string2 = "";
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof Element)) continue;
                if (((Element)nodeList.item(i)).getTagName().equals("Status")) {
                    string = ((Element)nodeList.item(i)).getTextContent();
                }
                if (!((Element)nodeList.item(i)).getTagName().equals("Message")) continue;
                string2 = ((Element)nodeList.item(i)).getTextContent();
            }
        }
        if (string.equals("FAILED")) {
            this.logger.error((Object)("The following error has been encountered: " + string2));
            return false;
        }
        return true;
    }

    public Package getPackage(GCUBEService gCUBEService, String string) {
        for (Package package_ : gCUBEService.getPackages()) {
            if (!package_.getName().equals(string)) continue;
            return package_;
        }
        return null;
    }

    public ArrayList<String> getFileList(Package package_) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (package_ instanceof Software) {
            for (String string : ((Software)package_).getFiles()) {
                int n = string.lastIndexOf("/");
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private boolean parseResources(NodeList nodeList) {
        boolean bl = true;
        int n = nodeList.getLength();
        int n2 = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) continue;
            NodeList nodeList2 = node.getChildNodes();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!(nodeList2.item(j) instanceof Element)) continue;
                if (((Element)nodeList2.item(j)).getTagName().equals("ID")) {
                    string = ((Element)nodeList2.item(j)).getTextContent();
                    continue;
                }
                if (((Element)nodeList2.item(j)).getTagName().equals("Type")) {
                    string2 = ((Element)nodeList2.item(j)).getTextContent();
                    continue;
                }
                if (((Element)nodeList2.item(j)).getTagName().equals("Status")) {
                    string3 = ((Element)nodeList2.item(j)).getTextContent();
                    continue;
                }
                if (!((Element)nodeList2.item(j)).getTagName().equals("ErrorDescription")) continue;
                string4 = ((Element)nodeList2.item(j)).getTextContent();
            }
            this.logger.info((Object)("Resource with ID " + string + " and  Type " + string2));
            this.logger.info((Object)"");
            this.logger.info((Object)("has been processed with status " + string3));
            if (!string3.equals("FAILED")) continue;
            ++n2;
            this.logger.info((Object)("Error Description : " + string4));
        }
        return n2 != n;
    }

    private boolean parseDependenciesResolutionStatus(NodeList nodeList) {
        boolean bl = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) continue;
            NodeList nodeList2 = node.getChildNodes();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!(nodeList2.item(j) instanceof Element)) continue;
                if (((Element)nodeList2.item(j)).getTagName().equals("Class")) {
                    string = ((Element)nodeList2.item(j)).getTextContent();
                    continue;
                }
                if (((Element)nodeList2.item(j)).getTagName().equals("Name")) {
                    string2 = ((Element)nodeList2.item(j)).getTextContent();
                    continue;
                }
                if (((Element)nodeList2.item(j)).getTagName().equals("DependenciesResolutionStatus")) {
                    string3 = ((Element)nodeList2.item(j)).getTextContent();
                    continue;
                }
                if (!((Element)nodeList2.item(j)).getTagName().equals("ErrorDescription")) continue;
                string4 = ((Element)nodeList2.item(j)).getTextContent();
            }
            this.logger.info((Object)("Dependency Resolution for Service " + string + "/" + string2));
            if (string3 != null) {
                this.logger.info((Object)("has been processed with status " + string3));
            } else {
                this.logger.info((Object)"not available");
            }
            if (string3 == null || !string3.equals("FAILED")) continue;
            this.logger.error((Object)("The following error has been encountered: " + string4));
            bl = false;
        }
        return bl;
    }

    private boolean checkPackagesDeployment(NodeList nodeList, boolean bl) {
        boolean bl2 = true;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) continue;
            NodeList nodeList2 = node.getChildNodes();
            String string = null;
            String string2 = null;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                if (!(nodeList2.item(j) instanceof Element)) continue;
                if (((Element)nodeList2.item(j)).getTagName().equals("ID")) {
                    string = ((Element)nodeList2.item(j)).getTextContent();
                    continue;
                }
                if (((Element)nodeList2.item(j)).getTagName().equals("Host")) {
                    string2 = ((Element)nodeList2.item(j)).getTextContent();
                    continue;
                }
                if (!((Element)nodeList2.item(j)).getTagName().equals("LastReportReceived")) continue;
                NodeList nodeList3 = ((Element)nodeList2.item(j)).getChildNodes();
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    if (!(nodeList3.item(k) instanceof Element) || !((Element)nodeList3.item(k)).getTagName().equals("Packages")) continue;
                    NodeList nodeList4 = ((Element)nodeList3.item(k)).getChildNodes();
                    for (int i2 = 0; i2 < nodeList4.getLength(); ++i2) {
                        Node node2 = nodeList4.item(i2);
                        if (node2 == null) continue;
                        NodeList nodeList5 = node2.getChildNodes();
                        String string3 = null;
                        String string4 = null;
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        GCUBEService gCUBEService = null;
                        for (int i3 = 0; i3 < nodeList5.getLength(); ++i3) {
                            if (!(nodeList5.item(i3) instanceof Element)) continue;
                            if (((Element)nodeList5.item(i3)).getTagName().equals("ServiceClass")) {
                                string4 = ((Element)nodeList5.item(i3)).getTextContent();
                                continue;
                            }
                            if (((Element)nodeList5.item(i3)).getTagName().equals("ServiceName")) {
                                string3 = ((Element)nodeList5.item(i3)).getTextContent();
                                continue;
                            }
                            if (((Element)nodeList5.item(i3)).getTagName().equals("PackageName")) {
                                string6 = ((Element)nodeList5.item(i3)).getTextContent();
                                continue;
                            }
                            if (((Element)nodeList5.item(i3)).getTagName().equals("Status")) {
                                string5 = ((Element)nodeList5.item(i3)).getTextContent();
                                continue;
                            }
                            if (!((Element)nodeList5.item(i3)).getTagName().equals("Message")) continue;
                            string7 = ((Element)nodeList5.item(i3)).getTextContent();
                        }
                        if (bl) {
                            ServiceInfo serviceInfo = null;
                            try {
                                serviceInfo = new ServiceInfo(string4, string3);
                                gCUBEService = this.isClient.getServiceProfile(serviceInfo);
                            }
                            catch (Exception exception) {
                                this.logger.error((Object)exception);
                                bl2 = false;
                            }
                            if (gCUBEService != null && this.getPackage(gCUBEService, string6) instanceof MainPackage) {
                                if (string5.equals("RUNNING")) continue;
                                this.logger.info((Object)"");
                                this.logger.info((Object)("On GHN with ID : " + string + " and name : " + string2));
                                this.logger.info((Object)"");
                                this.logger.error((Object)("FAILED - The Main Package (" + serviceInfo.toString() + "/" + string6 + ") is not running\n"));
                                bl2 = false;
                                continue;
                            }
                            if (gCUBEService != null && this.getPackage(gCUBEService, string6) instanceof Software) {
                                if (string5.equals("ACTIVATED")) continue;
                                if (string5.equals("ALREADYDEPLOYED")) {
                                    this.logger.info((Object)"");
                                    this.logger.info((Object)("On GHN with ID : " + string + " and name : " + string2));
                                    this.logger.info((Object)"");
                                    this.logger.info((Object)("The Software package (" + serviceInfo.toString() + "/" + string6 + ") is already deployed\n"));
                                    continue;
                                }
                                if (string5.equals("NOTVERIFIED")) continue;
                                this.logger.info((Object)"");
                                this.logger.info((Object)("On GHN with ID : " + string + " and name : " + string2));
                                this.logger.info((Object)"");
                                this.logger.error((Object)("FAILED - The Software package (" + serviceInfo.toString() + "/" + string6 + ") has not been activated \n"));
                                bl2 = false;
                                continue;
                            }
                            if (gCUBEService != null && this.getPackage(gCUBEService, string6) instanceof Plugin) {
                                if (string5.equals("REGISTERED")) continue;
                                this.logger.info((Object)"");
                                this.logger.info((Object)("FAILED - On GHN with ID : " + string + " and name : " + string2));
                                this.logger.info((Object)"");
                                this.logger.error((Object)("The Software package (" + serviceInfo.toString() + "/" + string6 + ") has not been Registered \n"));
                                bl2 = false;
                                continue;
                            }
                            this.logger.error((Object)"ERROR retrieving service infos");
                            bl2 = false;
                            continue;
                        }
                        if (string5.equals("UNDEPLOYED")) continue;
                        if (string5.equals("NOTUNDEPLOYABLE")) {
                            this.logger.info((Object)"");
                            this.logger.info((Object)("The Package (" + string4 + "/" + string3 + "/" + string6 + ") cannot be undeployed"));
                            this.logger.info((Object)("From GHN with ID : " + string + " and name : " + string2));
                            this.logger.info((Object)("Reason: " + string7));
                            bl2 = false;
                            continue;
                        }
                        this.logger.info((Object)"");
                        this.logger.info((Object)("FAILED - From GHN with ID : " + string + " and name : " + string2));
                        this.logger.info((Object)"");
                        this.logger.error((Object)("FAILED - The  package (" + string4 + "/" + string3 + "/" + string6 + ") has not been undeployed\n"));
                        bl2 = false;
                    }
                }
            }
        }
        return bl2;
    }

    public boolean checkDeploymentInfo() throws Exception {
        NodeList nodeList = this.getResources();
        if (nodeList == null) {
            this.logger.info((Object)"");
            this.logger.info((Object)"The deployment is still ongoing\n");
            return false;
        }
        if (!this.parseResources(nodeList)) {
            this.logger.info((Object)"");
            this.logger.error((Object)"The whole set of resource to deploy has failed\n");
            this.setGlobaloperationStatus(false);
            return true;
        }
        if (!this.getDeploymentPlanCreation()) {
            this.logger.info((Object)"");
            this.logger.info((Object)"one of the Deployment plan creation steps has failed\n");
            return false;
        }
        NodeList nodeList2 = this.getServices();
        if (nodeList2 == null) {
            this.logger.info((Object)"");
            this.logger.info((Object)"The deployment is still ongoing\n");
            return false;
        }
        if (!this.parseDependenciesResolutionStatus(nodeList2)) {
            this.logger.info((Object)"");
            this.logger.error((Object)"The deployment has failed because one/more dependency failed to be resolved\n");
            this.setGlobaloperationStatus(false);
        }
        if (this.getDeploymentActivityStatus()) {
            if (this.checkPackagesDeployment(this.getPackagesDeployed(), true)) {
                this.logger.info((Object)"");
                this.logger.info((Object)"SUCCESS - All packages correctly deployed/upgraded\n");
                this.setGlobaloperationStatus(true);
                return true;
            }
        } else {
            this.logger.info((Object)"");
            this.logger.info((Object)"The deployment is still ongoing\n");
            return false;
        }
        this.logger.info((Object)"");
        this.logger.info((Object)"WARNING - some operations reported Errors\n");
        return true;
    }

    public boolean checkOperationInfo() throws Exception {
        NodeList nodeList = this.getResources();
        if (nodeList == null) {
            this.logger.info((Object)"");
            this.logger.info((Object)"The operation is still ongoing\n");
            return false;
        }
        if (!this.parseResources(nodeList)) {
            this.logger.info((Object)"");
            if (this.getGlobalStatus().compareTo("CLOSED") == 0) {
                this.setGlobaloperationStatus(false);
            }
            return true;
        }
        this.logger.info((Object)"SUCCESS - The operation has been completed succesfully");
        this.setGlobaloperationStatus(true);
        return true;
    }

    public boolean checkUnDeploymentInfo() {
        NodeList nodeList;
        NodeList nodeList2 = this.getResources();
        if (nodeList2 == null) {
            this.logger.info((Object)"");
            this.logger.info((Object)"The undeployment is still ongoing\n");
            return false;
        }
        if (!this.parseResources(nodeList2)) {
            this.logger.info((Object)"");
            this.logger.info((Object)"The whole resource operations has failed\n");
            if (this.getGlobalStatus().compareTo("CLOSED") == 0) {
                this.setGlobaloperationStatus(false);
                return true;
            }
        }
        if ((nodeList = this.getServices()) == null) {
            this.logger.info((Object)"");
            this.logger.info((Object)"The undeployment is still ongoing\n");
            return false;
        }
        if (this.getDeploymentActivityStatus()) {
            if (this.checkPackagesDeployment(this.getPackagesDeployed(), false)) {
                this.logger.info((Object)"");
                this.logger.info((Object)"SUCCESS - All packages correctly undeployed\n");
                this.setGlobaloperationStatus(true);
                return true;
            }
        } else {
            this.logger.info((Object)"");
            this.logger.info((Object)"The undeployment is still ongoing\n");
            return false;
        }
        this.logger.info((Object)"");
        this.logger.info((Object)"WARNING - some operations reported Errors\n");
        return true;
    }

    public boolean checkSoftwareDeployment(ArrayList<String> arrayList) {
        boolean bl = true;
        if (arrayList == null) {
            this.logger.info((Object)"No deployment files to check");
            return true;
        }
        for (String string : arrayList) {
            if (new File(System.getenv("GLOBUS_LOCATION") + "/lib/" + string).exists()) {
                this.logger.info((Object)(string + " file has been correctly deployed"));
                continue;
            }
            this.logger.error((Object)(string + " IS MISSING!!"));
            bl = false;
        }
        return bl;
    }
}

