/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.resourcemanager.util;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.tools.resourcemanager.util.QueryInformationSystem;
import org.gcube.tools.resourcemanager.util.ServiceDeployment;

public class Util {
    public static String prepareDeploymentServiceTemplate(String string, String string2, String string3, GCUBEScope gCUBEScope) {
        return "numOfServicesToAdd=1\nnumOfResourcesToAdd=0\ntargetScope=" + gCUBEScope.toString() + "\n" + "callerScope=" + gCUBEScope.toString() + "\n" + "service.1.name=" + string + "\n" + "service.1.class=" + string2 + "\n" + "service.1.version=1.0.0\n" + "service.1.GHN=" + string3 + "\n";
    }

    public static String prepareUnDeploymentServiceTemplate(String string, String string2, String string3, GCUBEScope gCUBEScope) {
        return "numOfServicesToRemove=1\nnumOfResourcesToRemove=0\ntargetScope=" + gCUBEScope.toString() + "\n" + "callerScope=" + gCUBEScope.toString() + "\n" + "service.1.name=" + string + "\n" + "service.1.class=" + string2 + "\n" + "service.1.version=" + string3 + "\n";
    }

    public static ArrayList<ServiceDeployment> checkRIs(String[] stringArray, QueryInformationSystem queryInformationSystem, GCUBELog gCUBELog) throws Exception {
        ArrayList<ServiceDeployment> arrayList = new ArrayList<ServiceDeployment>();
        for (String string : stringArray) {
            List<GCUBERunningInstance> list = queryInformationSystem.getRunningInstance(string);
            if (list.size() > 1) {
                gCUBELog.debug((Object)("Duplicate Running intance on IS with id " + string));
                return null;
            }
            ServiceDeployment serviceDeployment = new ServiceDeployment();
            serviceDeployment.setServiceName(list.get(0).getServiceName());
            serviceDeployment.setServiceClass(list.get(0).getServiceClass());
            serviceDeployment.setGHN(list.get(0).getGHNID());
            serviceDeployment.setVersion("1.0.0");
            gCUBELog.debug((Object)"Adding info for redeployment");
            gCUBELog.debug((Object)("Running Instance with ID " + string));
            gCUBELog.debug((Object)("ServiceName: " + list.get(0).getServiceName()));
            gCUBELog.debug((Object)("ServiceClass: " + list.get(0).getServiceClass()));
            gCUBELog.debug((Object)("GHNID: " + list.get(0).getGHNID()));
            arrayList.add(serviceDeployment);
            ArrayList<GCUBEScope> arrayList2 = new ArrayList<GCUBEScope>();
            if (list.get(0).getScopes().size() <= 1) continue;
            gCUBELog.debug((Object)"");
            gCUBELog.debug((Object)("The Running Instance with ID " + string));
            gCUBELog.debug((Object)("ServiceName: " + list.get(0).getServiceName()));
            gCUBELog.debug((Object)("ServiceClass: " + list.get(0).getServiceClass()));
            gCUBELog.debug((Object)("GHNID: " + list.get(0).getGHNID()));
            gCUBELog.debug((Object)"Joins more than one scope :");
            for (GCUBEScope gCUBEScope : list.get(0).getScopes().values()) {
                if (!gCUBEScope.equals((Object)queryInformationSystem.getScope())) {
                    arrayList2.add(gCUBEScope);
                }
                gCUBELog.debug((Object)("Scope: " + gCUBEScope.toString()));
            }
            gCUBELog.debug((Object)"In order to undeploy/upgrade the RI from the node, you should previously remove the RI from ");
            for (GCUBEScope gCUBEScope : arrayList2) {
                gCUBELog.debug((Object)("Scope: " + gCUBEScope.toString()));
            }
            gCUBELog.debug((Object)"using the client with the REMOVE_SCOPE option");
            return null;
        }
        return arrayList;
    }

    public static GCUBESecurityManager generateAndConfigureDefaultSecurityManager(String string) {
        GCUBELog gCUBELog = new GCUBELog(Util.class);
        GCUBESecurityManagerImpl gCUBESecurityManagerImpl = null;
        if (GHNContext.getContext().isSecurityEnabled()) {
            try {
                gCUBELog.debug((Object)("Identity = " + string));
            }
            catch (Exception exception) {
                gCUBELog.error((Object)"Unable to generate default security manager: trying without security...", (Throwable)exception);
                gCUBESecurityManagerImpl = new GCUBESecurityManagerImpl(){

                    public boolean isSecurityEnabled() {
                        return GHNContext.getContext().isSecurityEnabled();
                    }
                };
            }
        } else {
            gCUBESecurityManagerImpl = new GCUBESecurityManagerImpl(){

                public boolean isSecurityEnabled() {
                    return GHNContext.getContext().isSecurityEnabled();
                }
            };
        }
        return gCUBESecurityManagerImpl;
    }

    public static enum Actions {
        DEPLOY("DEPLOY"),
        UNDEPLOY_RI("UNDEPLOY_RI"),
        UNDEPLOY_SA("UNDEPLOY_SA"),
        UPGRADE_RI("UPGRADE_RI"),
        UPGRADE_SA("UPGRADE_SA"),
        ADD_SCOPE("ADD_SCOPE"),
        REMOVE_SCOPE("REMOVE_SCOPE"),
        REPORT("REPORT");

        String type;

        private Actions(String string2) {
            this.type = string2;
        }

        public String toString() {
            return this.type;
        }
    }
}

