/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.portal.mailing.templates;

import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;

public abstract class AbstractTemplate {
    private String gatewayName;
    private String gatewayURL;
    private GroupManager gm;

    public AbstractTemplate(String gatewayName, String gatewayURL) {
        this.gatewayName = gatewayName;
        this.gatewayURL = gatewayURL;
        this.gm = new LiferayGroupManager();
    }

    public String getGatewayLogoURL() {
        long gatewayLogoId = 0L;
        try {
            long gatewayGroupId = this.gm.getGroupId(this.gatewayName);
            gatewayLogoId = this.gm.getGroup(gatewayGroupId).getLogoId();
            return this.gatewayURL + this.gm.getGroupLogoURL(gatewayLogoId);
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getGatewayName() {
        return this.gatewayName;
    }

    public String getGatewayURL() {
        return this.gatewayURL;
    }

    public GroupManager getGroupManagerImpl() {
        return this.gm;
    }
}

