package org.gcube.vomanagement.usermanagement.model;

import java.io.Serializable;

/**
 * The Class GCubeRole.
 */
@SuppressWarnings("serial")
public class GCubeRole implements Serializable {
	private long roleId;
	private	String roleName;
	private	String description;
	
	/** The Constant VRE_MANAGER_LABEL. */
	public final static String VRE_MANAGER_LABEL = "VRE-Manager";
	/** The Constant VRE_DESIGNER_LABEL. */
	public final static String VRE_DESIGNER_LABEL = "VRE-Designer";
	/** The Constant VO_ADMIN_LABEL. */
	public final static String VO_ADMIN_LABEL = "VRE-Designer";
	/** The Constant INFRA_MANAGER_LABEL. */
	public final static String INFRA_MANAGER_LABEL = "Infrastructure-Manager";
	/** The Constant DATA_MANAGER_LABEL. */
	public final static String DATA_MANAGER_LABEL = "Data-Manager";
		
	/**
	 * Instantiates a new g cube role.
	 */
	public GCubeRole(){
		
	}
	/**
	 * Instantiates a new g cube role.
	 *
	 * @param roleId the role id
	 * @param roleName the role name
	 * @param description the description
	 */
	public GCubeRole(long roleId, String roleName, String description){
		this.roleName = roleName;
		this.roleId = roleId;
		this.description = description;
	}
	
	/**
	 * Gets the role name.
	 *
	 * @return the role name
	 */
	public String getRoleName() {
		return roleName;
	}
	/**
	 * Sets the role name.
	 *
	 * @param roleName the new role name
	 */
	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}
	/**
	 * Gets the role id.
	 *
	 * @return the role id
	 */
	public long getRoleId() {
		return roleId;
	}
	/**
	 * Sets the role id.
	 *
	 * @param roleId the new role id
	 */
	public void setRoleId(long roleId) {
		this.roleId = roleId;
	}
	/**
	 * Gets the description.
	 *
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}
	/**
	 * Sets the description.
	 *
	 * @param description the new description
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	@Override
	public String toString() {
		return "GCubeRole [roleName=" + roleName + ", roleId=" + roleId
				+ ", description=" + description + "]";
	}

	
}
