package org.gcube.vremanagement.contextmanager;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType (XmlAccessType.FIELD)
public class ScopedResource {
	
	@XmlElement(name = "ResourceID")
	String id;
	
	@XmlElement(name = "ResourceType")
	String type;
	
	@XmlElement(name = "JointTime")
	String jointTime;
	
	@XmlElement(name = "HostedOn")
	String hostedOn;

	
	
	public ScopedResource(String id, String type, String jointTime) {
		super();
		this.id = id;
		this.type = type;
		this.jointTime = jointTime;
	}

	public ScopedResource(String id, String type, String jointTime, String hostedOn) {
		super();
		this.id = id;
		this.type = type;
		this.jointTime = jointTime;
		this.hostedOn = hostedOn;
	}

	@Override
	public String toString() {
		return "ScopedResource [id=" + id + ", type=" + type + ", jointTime=" + jointTime + ", hostedOn=" + hostedOn
				+ "]";
	}
	
}
